/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InspectPDF
extends AbstractTool {
    public InspectPDF() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The owner password if the file is encrypt"));
    }

    public static void main(String[] args) {
        InspectPDF tool = new InspectPDF();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Pdf Information", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Pdf Information OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            PdfReader reader = this.getValue("ownerpassword") == null ? new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath()) : new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            System.out.println("=== Document Information ===");
            System.out.println("PDF Version: " + reader.getPdfVersion());
            System.out.println("Number of pages: " + reader.getNumberOfPages());
            System.out.println("Number of PDF objects: " + reader.getXrefSize());
            System.out.println("File length: " + reader.getFileLength());
            System.out.println("Encrypted? " + reader.isEncrypted());
            if (reader.isEncrypted()) {
                System.out.println("Permissions: " + PdfEncryptor.getPermissionsVerbose((int)reader.getPermissions()));
                System.out.println("128 bit? " + reader.is128Key());
            }
            System.out.println("Rebuilt? " + reader.isRebuilt());
            System.out.println("=== Metadata ===");
            Map info = reader.getInfo();
            for (Map.Entry entry : info.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println(key + ": " + value);
            }
            if (reader.getMetadata() == null) {
                System.out.println("There is no XML Metadata in the file");
            } else {
                System.out.println("XML Metadata: " + new String(reader.getMetadata()));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        InspectPDF.addVersion("$Id: InspectPDF.java 3826 2009-03-31 17:46:18Z blowagie $");
    }
}

