/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.text.PageSize;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.OptionArgument;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PageSizeArgument
extends OptionArgument {
    private TreeMap<String, String> options = new TreeMap();

    public PageSizeArgument(AbstractTool tool, String name, String description) {
        super(tool, name, description);
        Class<PageSize> ps = PageSize.class;
        Field[] sizes = ps.getDeclaredFields();
        try {
            for (Field size : sizes) {
                this.addOption((Object)size.getName(), size.get(null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void addOption(String description, String value) {
        this.options.put(description, value);
    }

    public TreeMap<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return this.options.get(this.value);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        StringBuilder buf = new StringBuilder("  ");
        buf.append(this.name);
        buf.append(" -  ");
        buf.append(this.description);
        buf.append('\n');
        buf.append("    possible options:\n");
        Iterator<String> iterator = this.options.keySet().iterator();
        while (iterator.hasNext()) {
            String o;
            String s = o = iterator.next();
            buf.append("    - ");
            buf.append(s);
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[2];
        message[0] = "Choose one of the following pagesizes:";
        JComboBox<String> cb = new JComboBox<String>();
        for (String o : this.options.keySet()) {
            cb.addItem(o);
        }
        message[1] = cb;
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            this.setValue(cb.getSelectedItem());
        }
    }

    @Override
    public String toString() {
        return super.getValue().toString();
    }
}

