/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import java.awt.event.ActionEvent;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class OptionArgument
extends AbstractArgument {
    private TreeMap<String, Entry> options = new TreeMap();

    public OptionArgument(AbstractTool tool, String name, String description) {
        super(tool, name, description, null);
    }

    public void addOption(Object description, Object value) {
        this.options.put(value.toString(), new Entry(description, value));
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return this.options.get(this.value).getValue();
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        StringBuilder buf = new StringBuilder(super.getUsage());
        buf.append("    possible options:\n");
        for (Entry entry : this.options.values()) {
            buf.append("    - ");
            buf.append(entry.getValueToString());
            buf.append(": ");
            buf.append(entry.toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[2];
        message[0] = "Choose one of the following options:";
        JComboBox<Entry> cb = new JComboBox<Entry>();
        for (Entry entry : this.options.values()) {
            cb.addItem(entry);
        }
        message[1] = cb;
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            Entry entry;
            entry = (Entry)cb.getSelectedItem();
            this.setValue(entry.getValueToString());
        }
    }

    public class Entry {
        private Object description;
        private Object value;

        public Entry(Object value) {
            this.value = value;
            this.description = value;
        }

        public Entry(Object description, Object value) {
            this.description = description;
            this.value = value;
        }

        public String toString() {
            return this.description.toString();
        }

        public String getValueToString() {
            return this.value.toString();
        }

        public Object getDescription() {
            return this.description;
        }

        public void setDescription(Object description) {
            this.description = description;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

