/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.swing;

import com.lowagie.text.pdf.PdfReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileList
extends JInternalFrame
implements DropTargetListener {
    private static final long serialVersionUID = -7238230038043975672L;
    private final Vector<RowContainer> filevector = new Vector();
    private final JPanel jPanel1 = new JPanel();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JPanel jPanel2 = new JPanel();
    private final BorderLayout borderLayout2 = new BorderLayout();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final FileTableModel model = new FileTableModel();
    private final JTable jTable1 = new JTable(this.model);
    private final RowSorter<TableModel> sorter = new TableRowSorter<FileTableModel>(this.model);
    private final BorderLayout borderLayout3 = new BorderLayout();
    private final DropTarget dt = new DropTarget(this, 3, this, true, null);
    private final JPanel jPanel3 = new JPanel();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();

    public FileList() {
        super("FileList", true, true, true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jTable1.addKeyListener(new FileListJTable1KeyAdapter(this));
        this.jLabel1.setText("pages");
        this.jLabel2.setText("-");
        this.model.addTableModelListener(new FileListFtmTableModelAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add(this.jLabel2);
        this.jPanel3.add(this.jLabel1);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.setRowSorter(this.sorter);
        this.pack();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        System.out.println("actionchanged");
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if ((dtde.getDropAction() & 3) == 0) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(1);
        Transferable transferable = dtde.getTransferable();
        try {
            List filelist = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            for (File f : filelist) {
                this.filevector.add(new RowContainer(f));
                this.model.fireTableDataChanged();
                System.out.println(f.toString());
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ex.printStackTrace();
        }
        dtde.dropComplete(true);
        File[] filar = new File[this.filevector.size()];
        for (int i = 0; i < this.filevector.size(); ++i) {
            filar[i] = this.filevector.get(i).getFile();
        }
        super.firePropertyChange("filevector", null, filar);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    public void jTable1_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int[] selected = this.jTable1.getSelectedRows();
            for (int i = selected.length - 1; i >= 0; --i) {
                this.model.removeRow(selected[i]);
                this.model.fireTableDataChanged();
            }
        }
    }

    public void ftm_tableChanged(TableModelEvent e) {
        int sum = 0;
        for (RowContainer c : this.filevector) {
            sum += c.getPages();
        }
        this.jLabel2.setText(Integer.toString(sum));
    }

    public Vector<RowContainer> getFilevector() {
        return this.filevector;
    }

    public String getStringreprasentation() {
        StringBuilder sb = new StringBuilder();
        Vector<RowContainer> vec = this.getFilevector();
        for (RowContainer c : vec) {
            sb.append(c.getFile().getAbsolutePath()).append('\n');
        }
        return sb.toString();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class FileTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8173736343997473512L;
        private final String[] columnNames = new String[]{"Filename", "Pages", "Directory"};

        FileTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return FileList.this.filevector.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return FileList.this.filevector.get(row).getFile().getName();
                }
                case 1: {
                    return FileList.this.filevector.get(row).getPages();
                }
                case 2: {
                    return FileList.this.filevector.get(row).getFile().getParent();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        public void removeRow(int row) {
            FileList.this.filevector.remove(row);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class FileListJTable1KeyAdapter
    extends KeyAdapter {
        private final FileList adaptee;

        FileListJTable1KeyAdapter(FileList adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.adaptee.jTable1_keyPressed(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class FileListFtmTableModelAdapter
    implements TableModelListener {
        private final FileList adaptee;

        FileListFtmTableModelAdapter(FileList adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.adaptee.ftm_tableChanged(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class RowContainer {
        private File file;
        private int pages;

        public File getFile() {
            return this.file;
        }

        public int getPages() {
            return this.pages;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setPages(int pages) {
            this.pages = pages;
        }

        RowContainer(File file) {
            this.file = file;
            PdfReader reader = null;
            try {
                reader = new PdfReader(file.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.pages = reader.getNumberOfPages();
        }
    }
}

