/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins.watermarker;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.FloatArgument;
import com.lowagie.toolbox.arguments.IntegerArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.plugins.watermarker.Writer;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class WatermarkerTool
extends AbstractTool {
    FileArgument destfile;

    public WatermarkerTool() {
        FileArgument inputfile = new FileArgument(this, "srcfile", "The file you want to watermark", false, new PdfFilter());
        this.arguments.add(inputfile);
        this.arguments.add(new StringArgument(this, "watermark", "The text that can be used as watermark"));
        this.arguments.add(new IntegerArgument(this, "fontsize", "The fontsize of the watermark text"));
        this.arguments.add(new FloatArgument(this, "opacity", "The opacity of the watermark text"));
        this.destfile = new FileArgument(this, "destfile", "The file to which the watermarked PDF has to be written", true, new PdfFilter());
        this.arguments.add(this.destfile);
        this.arguments.add(new StringArgument(this, "color", "The color of the watermark text"));
        inputfile.addPropertyChangeListener(this.destfile);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Watermark", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Watermark OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            if (this.getValue("watermark") == null) {
                throw new InstantiationException("You need to add a text for the watermark");
            }
            if (this.getValue("fontsize") == null) {
                throw new InstantiationException("You need to add a fontsize for the watermark");
            }
            if (this.getValue("opacity") == null) {
                throw new InstantiationException("You need to add a opacity for the watermark");
            }
            Color color = Color.BLACK;
            if (this.getValue("color") != null) {
                color = Color.decode((String)this.getValue("color"));
            }
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")));
            String text = (String)this.getValue("watermark");
            int fontsize = Integer.parseInt((String)this.getValue("fontsize"));
            float opacity = Float.parseFloat((String)this.getValue("opacity"));
            Writer writer = new Writer(reader, stamp, text, fontsize, opacity, color);
            writer.write();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && arg.getName().equalsIgnoreCase("srcfile")) {
            String filename = arg.getValue().toString();
            String filenameout = filename.substring(0, filename.indexOf(".", filename.length() - 4)) + "_out.pdf";
            this.destfile.setValue(filenameout);
        }
    }

    public static void main(String[] args) {
        WatermarkerTool watermarkerTool = new WatermarkerTool();
        if (args.length < 5 || args.length > 6) {
            System.err.println(watermarkerTool.getUsage());
        }
        watermarkerTool.setMainArguments(args);
        watermarkerTool.execute();
    }
}

