/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Header;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.tools.Executable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class HtmlBookmarks
extends AbstractTool {
    public HtmlBookmarks() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The owner password if the file is encrypt"));
        this.arguments.add(new StringArgument(this, "css", "The path to a CSS file"));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Html Bookmarks", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Html Bookmarks OPENED ===");
    }

    @Override
    public void execute() {
        try {
            List list;
            Object title;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            PdfReader reader = this.getValue("ownerpassword") == null ? new PdfReader(src.getAbsolutePath()) : new PdfReader(src.getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            File directory = src.getParentFile();
            String name = src.getName();
            name = name.substring(0, name.lastIndexOf(46));
            File html = new File(directory, name + "_index.html");
            Document document = new Document();
            HtmlWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(html));
            Object css = this.getValue("css");
            if (css != null) {
                document.add((Element)new Header("stylesheet", css.toString()));
            }
            if ((title = reader.getInfo().get("Title")) == null) {
                document.addTitle("Index for " + src.getName());
            } else {
                document.addKeywords("Index for '" + title + "'");
            }
            Object keywords = reader.getInfo().get("Keywords");
            if (keywords != null) {
                document.addKeywords((String)keywords);
            }
            Object description = reader.getInfo().get("Subject");
            if (keywords != null) {
                document.addSubject((String)description);
            }
            document.open();
            Paragraph t = title == null ? new Paragraph("Index for " + src.getName()) : new Paragraph("Index for '" + title + "'");
            document.add((Element)t);
            if (description != null) {
                Paragraph d = new Paragraph((String)description);
                document.add((Element)d);
            }
            if ((list = SimpleBookmark.getBookmark((PdfReader)reader)) == null) {
                document.add((Element)new Paragraph("This document has no bookmarks."));
            } else {
                for (HashMap c : list) {
                    Chapter chapter = (Chapter)HtmlBookmarks.createBookmark(src.getName(), null, c);
                    List kids = (List)c.get("Kids");
                    if (kids != null) {
                        for (HashMap m : kids) {
                            HtmlBookmarks.addBookmark(src.getName(), (Section)chapter, m);
                        }
                    }
                    document.add((Element)chapter);
                }
            }
            document.close();
            Executable.launchBrowser(html.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    private static void addBookmark(String pdf, Section section, HashMap<String, Object> bookmark) {
        Section s = HtmlBookmarks.createBookmark(pdf, section, bookmark);
        List kids = (List)bookmark.get("Kids");
        if (kids == null) {
            return;
        }
        for (HashMap m : kids) {
            HtmlBookmarks.addBookmark(pdf, s, m);
        }
    }

    private static Section createBookmark(String pdf, Section section, HashMap<String, Object> bookmark) {
        Paragraph title = new Paragraph((String)bookmark.get("Title"));
        System.out.println((String)bookmark.get("Title"));
        String action = (String)bookmark.get("Action");
        if ("GoTo".equals(action)) {
            if (bookmark.get("Page") != null) {
                String page = (String)bookmark.get("Page");
                StringTokenizer tokens = new StringTokenizer(page);
                String token = tokens.nextToken();
                Anchor anchor = new Anchor(" page" + token);
                anchor.setReference(pdf + "#page=" + token);
                title.add((Object)anchor);
            }
        } else if ("URI".equals(action)) {
            String url = (String)bookmark.get("URI");
            Anchor anchor = new Anchor(" Goto URL");
            anchor.setReference(url);
            title.add((Object)anchor);
        } else if ("GoToR".equals(action)) {
            String remote = (String)bookmark.get("File");
            Anchor anchor = new Anchor(" goto " + remote);
            if (bookmark.get("Named") != null) {
                String named = (String)bookmark.get("Named");
                remote = remote + "#nameddest=" + named;
            } else if (bookmark.get("Page") != null) {
                String page = (String)bookmark.get("Page");
                StringTokenizer tokens = new StringTokenizer(page);
                String token = tokens.nextToken();
                anchor.add((Object)new Chunk(" page " + token));
                remote = remote + "#page=" + token;
            }
            anchor.setReference(remote);
            title.add((Object)anchor);
        }
        Object s = section == null ? new Chapter(title, 0) : section.addSection(title);
        s.setNumberDepth(0);
        return s;
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        HtmlBookmarks tool = new HtmlBookmarks();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        HtmlBookmarks.addVersion("$Id: HtmlBookmarks.java 3373 2008-05-12 16:21:24Z xlv $");
    }
}

