/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.text.PageSize;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.OptionArgument;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class PageSizeArgument
extends OptionArgument {
    private TreeMap<Object, Object> options = new TreeMap();

    public PageSizeArgument(AbstractTool tool, String name, String description) {
        super(tool, name, description);
        Class<PageSize> ps = PageSize.class;
        Field[] sizes = ps.getDeclaredFields();
        try {
            for (int i = 0; i < sizes.length; ++i) {
                this.addOption(sizes[i].getName(), sizes[i].get(null));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addOption(Object description, Object value) {
        this.options.put(description, value);
    }

    public TreeMap<Object, Object> getOptions() {
        return this.options;
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return this.options.get(this.value);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        StringBuffer buf = new StringBuffer("  ");
        buf.append(this.name);
        buf.append(" -  ");
        buf.append(this.description);
        buf.append('\n');
        buf.append("    possible options:\n");
        for (String string : this.options.keySet()) {
            buf.append("    - ");
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[2];
        message[0] = "Choose one of the following pagesizes:";
        JComboBox<Object> cb = new JComboBox<Object>();
        Iterator<Object> i = this.options.keySet().iterator();
        while (i.hasNext()) {
            cb.addItem(i.next());
        }
        message[1] = cb;
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            this.setValue(cb.getSelectedItem());
        }
    }

    @Override
    public String toString() {
        return super.getValue().toString();
    }
}

