/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.view.itext;

import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import org.openpdf.rups.controller.PdfReaderController;
import org.openpdf.rups.model.IndirectObjectFactory;
import org.openpdf.rups.model.ObjectLoader;
import org.openpdf.rups.view.models.JTableAutoModel;
import org.openpdf.rups.view.models.JTableAutoModelInterface;
import org.openpdf.text.pdf.PdfNull;
import org.openpdf.text.pdf.PdfObject;

public class XRefTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    private static final long serialVersionUID = -382184619041375537L;
    protected IndirectObjectFactory objects;
    protected PdfReaderController controller;

    public XRefTable(PdfReaderController controller) {
        this.controller = controller;
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.objects = null;
            this.repaint();
            return;
        }
        if (observable instanceof PdfReaderController && obj instanceof ObjectLoader) {
            ObjectLoader loader = (ObjectLoader)obj;
            this.objects = loader.getObjects();
            this.setModel(new JTableAutoModel(this));
            TableColumn col = this.getColumnModel().getColumn(0);
            col.setPreferredWidth(5);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getObjectReferenceByRow(rowIndex);
            }
            case 1: {
                return this.getObjectDescriptionByRow(rowIndex);
            }
        }
        return null;
    }

    protected int getObjectReferenceByRow(int rowIndex) {
        return this.objects.getRefByIndex(rowIndex);
    }

    protected String getObjectDescriptionByRow(int rowIndex) {
        PdfObject object = this.objects.getObjectByIndex(rowIndex);
        if (object instanceof PdfNull) {
            return "Indirect object";
        }
        return object.toString();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Number";
            }
            case 1: {
                return "Object";
            }
        }
        return null;
    }

    protected PdfObject getObjectByRow(int rowIndex) {
        return this.objects.loadObjectByReference(this.getObjectReferenceByRow(rowIndex));
    }

    public void selectRowByReference(int ref) {
        int row = this.objects.getIndexByRef(ref);
        this.setRowSelectionInterval(row, row);
        this.scrollRectToVisible(this.getCellRect(row, 1, true));
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt != null) {
            super.valueChanged(evt);
        }
        if (this.controller != null && this.objects != null) {
            this.controller.render(this.getObjectByRow(this.getSelectedRow()));
            this.controller.selectNode(this.getObjectReferenceByRow(this.getSelectedRow()));
        }
    }
}

