/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.model;

import java.util.Observable;
import org.openpdf.rups.model.BackgroundTask;
import org.openpdf.rups.model.IndirectObjectFactory;
import org.openpdf.rups.model.ProgressDialog;
import org.openpdf.rups.model.TreeNodeFactory;
import org.openpdf.text.pdf.PdfReader;

public class ObjectLoader
extends BackgroundTask {
    protected Observable observable;
    protected PdfReader reader;
    protected IndirectObjectFactory objects;
    protected TreeNodeFactory nodes;

    public ObjectLoader(Observable observable, PdfReader reader) {
        this.observable = observable;
        this.reader = reader;
        this.start();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public IndirectObjectFactory getObjects() {
        return this.objects;
    }

    public TreeNodeFactory getNodes() {
        return this.nodes;
    }

    @Override
    public void doTask() {
        ProgressDialog progress = new ProgressDialog(null, "Reading PDF file");
        this.objects = new IndirectObjectFactory(this.reader);
        int n = this.objects.getXRefMaximum();
        progress.setMessage("Reading the Cross-Reference table");
        progress.setTotal(n);
        while (this.objects.storeNextObject()) {
            progress.setValue(this.objects.getCurrent());
        }
        progress.setTotal(0);
        this.nodes = new TreeNodeFactory(this.objects);
        progress.setMessage("Updating GUI");
        this.observable.notifyObservers(this);
        progress.dispose();
    }
}

