/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import javax.swing.SwingUtilities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BackgroundTask {
    private ThreadWrapper thread;

    public BackgroundTask() {
        Runnable doFinished = this::finished;
        Runnable doConstruct = () -> {
            try {
                this.doTask();
            }
            finally {
                this.thread.clear();
            }
            SwingUtilities.invokeLater(doFinished);
        };
        Thread t = new Thread(doConstruct);
        this.thread = new ThreadWrapper(t);
    }

    public abstract void doTask();

    public void start() {
        Thread t = this.thread.get();
        if (t != null) {
            t.start();
        }
    }

    public void interrupt() {
        Thread t = this.thread.get();
        if (t != null) {
            t.interrupt();
        }
        this.thread.clear();
    }

    public void finished() {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ThreadWrapper {
        private Thread thread;

        ThreadWrapper(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

