/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.rtf.parser.RtfImportMgr;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class RtfDestinationColorTable
extends RtfDestination {
    private RtfImportMgr importHeader = null;
    private int colorNr = 0;
    private int red = -1;
    private int green = -1;
    private int blue = -1;
    private int ctint = 255;
    private int cshade = 255;
    private int themeColor = -1;
    private Map<String, Color> colorMap = new HashMap<String, Color>();

    public RtfDestinationColorTable() {
        super(null);
    }

    public RtfDestinationColorTable(RtfParser parser) {
        super(parser);
        this.importHeader = parser.getImportManager();
        this.setToDefaults();
    }

    @Override
    public void setParser(RtfParser parser) {
        this.rtfParser = parser;
        this.colorMap = new HashMap<String, Color>();
        this.colorNr = 0;
        this.importHeader = parser.getImportManager();
        this.setToDefaults();
    }

    @Override
    public boolean handleOpeningSubGroup() {
        return true;
    }

    @Override
    public boolean closeDestination() {
        return true;
    }

    @Override
    public boolean handleCloseGroup() {
        this.processColor();
        return true;
    }

    @Override
    public boolean handleOpenGroup() {
        return true;
    }

    @Override
    public boolean handleCharacter(int ch) {
        if (ch == 59) {
            this.processColor();
        }
        return true;
    }

    @Override
    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        if (ctrlWordData.ctrlWord.equals("blue")) {
            this.setBlue(ctrlWordData.intValue());
        }
        if (ctrlWordData.ctrlWord.equals("red")) {
            this.setRed(ctrlWordData.intValue());
        }
        if (ctrlWordData.ctrlWord.equals("green")) {
            this.setGreen(ctrlWordData.intValue());
        }
        if (ctrlWordData.ctrlWord.equals("cshade")) {
            this.setShade(ctrlWordData.intValue());
        }
        if (ctrlWordData.ctrlWord.equals("ctint")) {
            this.setTint(ctrlWordData.intValue());
        }
        return true;
    }

    @Override
    public void setToDefaults() {
        this.red = -1;
        this.green = -1;
        this.blue = -1;
        this.ctint = 255;
        this.cshade = 255;
        this.themeColor = -1;
    }

    private void processColor() {
        if (this.red != -1 && this.green != -1 && this.blue != -1) {
            if (this.rtfParser.isImport()) {
                this.importHeader.importColor(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
            if (this.rtfParser.isConvert()) {
                this.colorMap.put(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
        }
        this.setToDefaults();
        ++this.colorNr;
    }

    private void setRed(int value) {
        if (value >= 0 && value <= 255) {
            this.red = value;
        }
    }

    private void setGreen(int value) {
        if (value >= 0 && value <= 255) {
            this.green = value;
        }
    }

    private void setBlue(int value) {
        if (value >= 0 && value <= 255) {
            this.blue = value;
        }
    }

    private void setTint(int value) {
        if (value >= 0 && value <= 255) {
            this.ctint = value;
            if (value >= 0 && value < 255) {
                this.cshade = 255;
            }
        }
    }

    private void setShade(int value) {
        if (value >= 0 && value <= 255) {
            this.cshade = value;
            if (value >= 0 && value < 255) {
                this.ctint = 255;
            }
        }
    }

    private void setThemeColor(int value) {
        this.themeColor = value >= -1 && value <= 15 ? value : -1;
    }

    public Color getColor(String key) {
        return this.colorMap.get(key);
    }
}

