/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.utils.LongMappedByteBuffer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

@Deprecated
public class MappedRandomAccessFile
implements AutoCloseable {
    private LongMappedByteBuffer mappedByteBuffer = null;
    private FileChannel channel = null;

    public MappedRandomAccessFile(String filename, String mode) throws IOException {
        if (mode.equals("rw")) {
            this.init(new RandomAccessFile(filename, mode).getChannel(), FileChannel.MapMode.READ_WRITE);
        } else {
            this.init(new FileInputStream(filename).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
    }

    private void init(FileChannel channel, FileChannel.MapMode mapMode) throws IOException {
        this.channel = channel;
        this.mappedByteBuffer = new LongMappedByteBuffer(channel, mapMode);
        this.mappedByteBuffer.load();
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public int read() {
        long limit;
        long pos = this.mappedByteBuffer.position();
        if (pos >= (limit = this.mappedByteBuffer.limit())) {
            return -1;
        }
        byte b = this.mappedByteBuffer.get(pos);
        this.mappedByteBuffer.position(pos + 1L);
        return b & 0xFF;
    }

    public int read(byte[] bytes, int off, int len) {
        int totalRead;
        int n;
        long limit;
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        long pos = this.mappedByteBuffer.position();
        if (pos >= (limit = this.mappedByteBuffer.limit())) {
            return -1;
        }
        int remaining = (int)Math.min((long)len, limit - pos);
        if (remaining <= 0) {
            return -1;
        }
        for (totalRead = 0; totalRead < remaining && (n = this.mappedByteBuffer.read(bytes, off + totalRead, remaining - totalRead)) > 0; totalRead += n) {
        }
        return totalRead == 0 ? -1 : totalRead;
    }

    public long getFilePointer() {
        return this.mappedByteBuffer.position();
    }

    public void seek(long pos) {
        this.mappedByteBuffer.position(pos);
    }

    public long length() {
        return this.mappedByteBuffer.limit();
    }

    @Override
    public void close() throws IOException {
        this.mappedByteBuffer = null;
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
    }
}

