/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.decode;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFParseException;
import org.openpdf.renderer.decode.ASCII85Decode;
import org.openpdf.renderer.decode.ASCIIHexDecode;
import org.openpdf.renderer.decode.CCITTFaxDecode;
import org.openpdf.renderer.decode.FlateDecode;
import org.openpdf.renderer.decode.JPXDecode;
import org.openpdf.renderer.decode.LZWDecode;
import org.openpdf.renderer.decode.RunLengthDecode;

public class PDFDecoder {
    public static final Set<String> DCT_FILTERS = new HashSet<String>(Arrays.asList("DCT", "DCTDecode"));

    private PDFDecoder() {
    }

    public static boolean isLastFilter(PDFObject dict, Set<String> filters) throws IOException {
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return false;
        }
        if (filter.getType() == 4) {
            return filters.contains(filter.getStringValue());
        }
        PDFObject[] ary = filter.getArray();
        return filters.contains(ary[ary.length - 1].getStringValue());
    }

    public static ByteBuffer decodeStream(PDFObject dict, ByteBuffer streamBuf, Set<String> filterLimits) throws IOException {
        boolean specificCryptFilter;
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return dict.getDecrypter().decryptBuffer(null, dict, streamBuf);
        }
        FilterSpec spec = new FilterSpec(dict, filter);
        boolean bl = specificCryptFilter = spec.ary.length != 0 && spec.ary[0].getStringValue().equals("Crypt");
        if (!specificCryptFilter) {
            streamBuf = dict.getDecrypter().decryptBuffer(null, dict, streamBuf);
        }
        for (int i = 0; i < spec.ary.length; ++i) {
            String enctype = spec.ary[i].getStringValue();
            try {
                if (filterLimits.contains(enctype)) break;
                if (enctype == null) continue;
                if (enctype.equals("FlateDecode") || enctype.equals("Fl")) {
                    streamBuf = FlateDecode.decode(dict, streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("LZWDecode") || enctype.equals("LZW")) {
                    streamBuf = LZWDecode.decode(streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("ASCII85Decode") || enctype.equals("A85")) {
                    streamBuf = ASCII85Decode.decode(streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("ASCIIHexDecode") || enctype.equals("AHx")) {
                    streamBuf = ASCIIHexDecode.decode(streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("RunLengthDecode") || enctype.equals("RL")) {
                    streamBuf = RunLengthDecode.decode(streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("JPXDecode")) {
                    streamBuf = JPXDecode.decode(dict, streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("CCITTFaxDecode") || enctype.equals("CCF")) {
                    streamBuf = CCITTFaxDecode.decode(dict, streamBuf, spec.params[i]);
                    continue;
                }
                if (enctype.equals("Crypt")) {
                    PDFObject nameObj;
                    String cfName = "Identity";
                    if (spec.params[i] != null && (nameObj = spec.params[i].getDictRef("Name")) != null && nameObj.getType() == 4) {
                        cfName = nameObj.getStringValue();
                    }
                    streamBuf = dict.getDecrypter().decryptBuffer(cfName, null, streamBuf);
                    continue;
                }
                throw new PDFParseException("Unknown coding method:" + spec.ary[i].getStringValue());
            }
            catch (Exception e) {
                throw new PDFParseException("Problem decoding " + enctype + " encoded stream!", e);
            }
        }
        return streamBuf;
    }

    private static String getCryptFilterName(PDFObject param) throws IOException {
        PDFObject nameObj;
        String cfName = "Identity";
        if (param != null && (nameObj = param.getDictRef("Name")) != null && nameObj.getType() == 4) {
            cfName = nameObj.getStringValue();
        }
        return cfName;
    }

    public static boolean isEncrypted(PDFObject dict) throws IOException {
        boolean specificCryptFilter;
        PDFObject filter = dict.getDictRef("Filter");
        if (filter == null) {
            return dict.getDecrypter().isEncryptionPresent();
        }
        FilterSpec spec = new FilterSpec(dict, filter);
        boolean bl = specificCryptFilter = spec.ary.length != 0 && spec.ary[0].getStringValue().equals("Crypt");
        if (!specificCryptFilter) {
            return dict.getDecrypter().isEncryptionPresent();
        }
        String cfName = PDFDecoder.getCryptFilterName(spec.params[0]);
        return dict.getDecrypter().isEncryptionPresent(cfName);
    }

    private static class FilterSpec {
        PDFObject[] ary;
        PDFObject[] params;

        private FilterSpec(PDFObject dict, PDFObject filter) throws IOException {
            if (filter.getType() == 4) {
                this.ary = new PDFObject[1];
                this.ary[0] = filter;
                this.params = new PDFObject[1];
                this.params[0] = dict.getDictRef("DecodeParms");
            } else {
                this.ary = filter.getArray();
                PDFObject parmsobj = dict.getDictRef("DecodeParms");
                this.params = parmsobj != null ? parmsobj.getArray() : new PDFObject[this.ary.length];
            }
        }
    }
}

