/*
 * Decompiled with CFR 0.152.
 */
package com.github.librepdf.kotlin;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openpdf.text.Document;
import org.openpdf.text.Element;
import org.openpdf.text.Font;
import org.openpdf.text.Image;
import org.openpdf.text.Paragraph;
import org.openpdf.text.pdf.PdfWriter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\b\u000eJ\"\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J)\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/librepdf/kotlin/PdfBuilder;", "", "outputStream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "document", "Lorg/openpdf/text/Document;", "writer", "Lorg/openpdf/text/pdf/PdfWriter;", "build", "", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "paragraph", "text", "", "alignment", "", "font", "Lorg/openpdf/text/Font;", "image", "path", "scalePercent", "", "(Ljava/lang/String;Ljava/lang/Float;I)V", "lineBreak", "lines", "title", "subtitle", "openpdf-kotlin"})
@SourceDebugExtension(value={"SMAP\nPdfBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfBuilder.kt\ncom/github/librepdf/kotlin/PdfBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class PdfBuilder {
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final Document document;
    @Nullable
    private PdfWriter writer;

    public PdfBuilder(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
        this.document = new Document();
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outputStream);
    }

    public final void build(@NotNull Function1<? super PdfBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.document.open();
        content.invoke((Object)this);
        this.document.close();
    }

    public final void paragraph(@NotNull String text, int alignment, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Paragraph para = new Paragraph(text, font);
        para.setAlignment(alignment);
        this.document.add((Element)para);
    }

    public static /* synthetic */ void paragraph$default(PdfBuilder pdfBuilder, String string, int n, Font font, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            font = new Font(1, 12.0f);
        }
        pdfBuilder.paragraph(string, n, font);
    }

    public final void image(@NotNull String path, @Nullable Float scalePercent, int alignment) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Image img = Image.getInstance((String)path);
        Float f = scalePercent;
        if (f != null) {
            float it = ((Number)f).floatValue();
            boolean bl = false;
            img.scalePercent(it);
        }
        img.setAlignment(alignment);
        this.document.add((Element)img);
    }

    public static /* synthetic */ void image$default(PdfBuilder pdfBuilder, String string, Float f, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = null;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        pdfBuilder.image(string, f, n);
    }

    public final void lineBreak(int lines) {
        int n = 0;
        while (n < lines) {
            int it = n++;
            boolean bl = false;
            this.document.add((Element)new Paragraph(" "));
        }
    }

    public static /* synthetic */ void lineBreak$default(PdfBuilder pdfBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        pdfBuilder.lineBreak(n);
    }

    public final void title(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.paragraph(text, 1, new Font(1, 16.0f, 1));
    }

    public final void subtitle(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.paragraph(text, 1, new Font(1, 13.0f, 2));
    }

    @Nullable
    public final PdfWriter writer() {
        return this.writer;
    }
}

