/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.context.ReadContext;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.FieldDefinition;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelReader<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelReader.class);
    private static final int DEFAULT_SHEET_INDEX = 0;
    private final Class<T> dataType;
    private int sheetIndex = 0;
    private Predicate<Row> rowFilter = row -> true;
    private Predicate<T> beanFilter = bean -> true;
    private Workbook wb;
    private BiFunction<Throwable, ReadContext, Boolean> exceptionFunction = (e, c) -> false;
    private final ReadContext<T> readContext = new ReadContext(new ConvertContext(false));
    private Map<String, XSSFPicture> xssfPicturesMap = Collections.emptyMap();
    private Map<String, HSSFPicture> hssfPictureMap = Collections.emptyMap();
    private boolean isXSSFSheet;
    private String sheetName;
    private Function<String, String> trim = v -> {
        if (v == null) {
            return v;
        }
        return v.trim();
    };
    private Consumer<Sheet> startSheetConsumer = sheet -> {};

    private DefaultExcelReader(Class<T> dataType) {
        this.dataType = dataType;
        if (dataType != Map.class) {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
            ConfigurationUtil.parseConfiguration(classFieldContainer, this.readContext.convertContext.configuration);
            List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
            fields.forEach(field -> {
                ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                if (excelColumn == null) {
                    return;
                }
                ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
                this.readContext.convertContext.excelColumnMappingMap.put((Field)field, mapping);
            });
        }
    }

    public static <T> DefaultExcelReader<T> of(Class<T> clazz) {
        return new DefaultExcelReader<T>(clazz);
    }

    public DefaultExcelReader<T> sheet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Sheet index must be greater than or equal to 0");
        }
        this.sheetIndex = index;
        return this;
    }

    public DefaultExcelReader<T> sheet(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public DefaultExcelReader<T> rowFilter(Predicate<Row> rowFilter) {
        this.rowFilter = rowFilter;
        return this;
    }

    public DefaultExcelReader<T> beanFilter(Predicate<T> beanFilter) {
        this.beanFilter = beanFilter;
        return this;
    }

    public DefaultExcelReader<T> exceptionally(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        this.exceptionFunction = exceptionFunction;
        return this;
    }

    public DefaultExcelReader<T> noTrim() {
        this.trim = v -> v;
        return this;
    }

    public DefaultExcelReader<T> startSheet(Consumer<Sheet> startSheetConsumer) {
        this.startSheetConsumer = startSheetConsumer;
        return this;
    }

    public List<T> read(InputStream fileInputStream) {
        return this.read(fileInputStream, null);
    }

    public List<T> read(InputStream fileInputStream, String password) {
        return this.doRead(() -> this.getSheetOfInputStream(fileInputStream, password));
    }

    public List<T> read(File file) {
        return this.read(file, null);
    }

    public List<T> read(File file, String password) {
        return this.doRead(() -> this.getSheetOfFile(file, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> doRead(Supplier<Sheet> sheetSupplier) {
        Map<Integer, FieldDefinition> fieldDefinitionMap = ReflectUtil.getFieldDefinitionMapOfExcelColumn(this.dataType);
        if (fieldDefinitionMap.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Sheet sheet = sheetSupplier.get();
            this.startSheetConsumer.accept(sheet);
            List<T> list = this.getDataFromFile(sheet, fieldDefinitionMap);
            return list;
        }
        finally {
            this.clearWorkbook();
        }
    }

    public void readThen(InputStream fileInputStream, Consumer<T> consumer) {
        this.readThen(fileInputStream, null, consumer);
    }

    public void readThen(InputStream fileInputStream, String password, Consumer<T> consumer) {
        this.doReadThen(() -> this.getSheetOfInputStream(fileInputStream, password), consumer, null);
    }

    public void readThen(File file, Consumer<T> consumer) {
        this.readThen(file, null, consumer);
    }

    public void readThen(File file, String password, Consumer<T> consumer) {
        this.doReadThen(() -> this.getSheetOfFile(file, password), consumer, null);
    }

    public void readThen(InputStream fileInputStream, Function<T, Boolean> function) {
        this.readThen(fileInputStream, null, function);
    }

    public void readThen(InputStream fileInputStream, String password, Function<T, Boolean> function) {
        this.doReadThen(() -> this.getSheetOfInputStream(fileInputStream, password), null, function);
    }

    public void readThen(File file, Function<T, Boolean> function) {
        this.readThen(file, null, function);
    }

    public void readThen(File file, String password, Function<T, Boolean> function) {
        this.doReadThen(() -> this.getSheetOfFile(file, password), null, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadThen(Supplier<Sheet> sheetSupplier, Consumer<T> consumer, Function<T, Boolean> function) {
        Map<Integer, FieldDefinition> fieldDefinitionMap = ReflectUtil.getFieldDefinitionMapOfExcelColumn(this.dataType);
        if (fieldDefinitionMap.isEmpty()) {
            return;
        }
        try {
            Sheet sheet = sheetSupplier.get();
            this.readThenConsume(sheet, fieldDefinitionMap, consumer, function);
        }
        finally {
            this.clearWorkbook();
        }
    }

    private void clearWorkbook() {
        if (Objects.nonNull(this.wb)) {
            try {
                this.wb.close();
            }
            catch (IOException e) {
                throw new ExcelReadException("Close workbook failure", e);
            }
        }
    }

    private Sheet getSheetOfInputStream(InputStream fileInputStream, String password) {
        try {
            this.wb = StringUtil.isBlank(password) ? WorkbookFactory.create((InputStream)fileInputStream) : WorkbookFactory.create((InputStream)fileInputStream, (String)password);
        }
        catch (IOException | EncryptedDocumentException e) {
            throw new ExcelReadException("Get sheet of excel failure", e);
        }
        return this.getSheet();
    }

    private Sheet getSheetOfFile(File file, String password) {
        try {
            this.wb = StringUtil.isBlank(password) ? WorkbookFactory.create((File)file) : WorkbookFactory.create((File)file, (String)password);
        }
        catch (IOException | EncryptedDocumentException e) {
            throw new ExcelReadException("Get sheet of excel failure", e);
        }
        return this.getSheet();
    }

    private Sheet getSheet() {
        Sheet sheet;
        if (this.sheetName != null) {
            sheet = this.wb.getSheet(this.sheetName);
            if (sheet == null) {
                throw new ExcelReadException("Cannot find sheet based on sheetName:" + this.sheetName);
            }
        } else {
            sheet = this.wb.getSheetAt(this.sheetIndex);
        }
        this.getAllPictures(sheet);
        return sheet;
    }

    private List<T> getDataFromFile(Sheet sheet, Map<Integer, FieldDefinition> fieldDefinitionMap) {
        long startTime = System.currentTimeMillis();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        log.info("FirstRowNum:{},LastRowNum:{}", (Object)firstRowNum, (Object)lastRowNum);
        if (lastRowNum < 0) {
            log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
            return Collections.emptyList();
        }
        DataFormatter formatter = new DataFormatter();
        LinkedList<T> result = new LinkedList<T>();
        for (int i = firstRowNum; i <= lastRowNum; ++i) {
            T obj;
            Row row = sheet.getRow(i);
            if (row == null) {
                log.info("Row of {} is null,it will be ignored.", (Object)i);
                continue;
            }
            boolean noMatchResult = this.rowFilter.negate().test(row);
            if (noMatchResult) {
                log.info("Row of {} does not meet the filtering criteria, it will be ignored.", (Object)i);
                continue;
            }
            short lastColNum = row.getLastCellNum();
            if (lastColNum < 0 || !this.beanFilter.test(obj = this.instanceObj(fieldDefinitionMap, formatter, row))) continue;
            result.add(obj);
        }
        log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void readThenConsume(Sheet sheet, Map<Integer, FieldDefinition> fieldDefinitionMap, Consumer<T> consumer, Function<T, Boolean> function) {
        long startTime = System.currentTimeMillis();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        log.info("FirstRowNum:{},LastRowNum:{}", (Object)firstRowNum, (Object)lastRowNum);
        this.startSheetConsumer.accept(sheet);
        if (lastRowNum < 0) {
            log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
            return;
        }
        DataFormatter formatter = new DataFormatter();
        for (int i = firstRowNum; i <= lastRowNum; ++i) {
            Boolean noStop;
            T obj;
            Row row = sheet.getRow(i);
            if (row == null) {
                log.info("Row of {} is null,it will be ignored.", (Object)i);
                continue;
            }
            boolean noMatchResult = this.rowFilter.negate().test(row);
            if (noMatchResult) {
                log.info("Row of {} does not meet the filtering criteria, it will be ignored.", (Object)i);
                continue;
            }
            short lastColNum = row.getLastCellNum();
            if (lastColNum < 0 || !this.beanFilter.test(obj = this.instanceObj(fieldDefinitionMap, formatter, row))) continue;
            if (consumer != null) {
                consumer.accept(obj);
                continue;
            }
            if (function != null && !(noStop = function.apply(obj)).booleanValue()) break;
        }
        log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
    }

    private void getAllPictures(Sheet sheet) {
        if (sheet instanceof XSSFSheet) {
            this.isXSSFSheet = true;
            XSSFDrawing xssfDrawing = ((XSSFSheet)sheet).getDrawingPatriarch();
            if (xssfDrawing == null) {
                return;
            }
            this.xssfPicturesMap = xssfDrawing.getShapes().stream().filter(s -> s instanceof XSSFPicture).map(s -> (XSSFPicture)s).collect(Collectors.toMap(s -> {
                XSSFClientAnchor anchor = (XSSFClientAnchor)s.getAnchor();
                return anchor.getRow1() + "_" + anchor.getCol1();
            }, s -> s));
        } else if (sheet instanceof HSSFSheet) {
            HSSFPatriarch hssfPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch();
            if (hssfPatriarch == null) {
                return;
            }
            Spliterator spliterator = hssfPatriarch.spliterator();
            this.hssfPictureMap = new HashMap<String, HSSFPicture>();
            spliterator.forEachRemaining(shape -> {
                HSSFPicture picture;
                HSSFAnchor anchor;
                if (shape instanceof HSSFPicture && (anchor = (picture = (HSSFPicture)shape).getAnchor()) instanceof HSSFClientAnchor) {
                    int row = ((HSSFClientAnchor)anchor).getRow1();
                    short col = ((HSSFClientAnchor)anchor).getCol1();
                    this.hssfPictureMap.put(row + "_" + col, picture);
                }
            });
        }
    }

    private T instanceObj(Map<Integer, FieldDefinition> fieldDefinitionMap, DataFormatter formatter, Row row) {
        T obj = ReflectUtil.newInstance(this.dataType);
        fieldDefinitionMap.forEach((index, fieldDefinition) -> {
            if (fieldDefinition.getField().getType() == InputStream.class) {
                this.convertPicture(row, obj, (Integer)index, fieldDefinition.getField());
                return;
            }
            Cell cell = row.getCell(index.intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (cell == null) {
                return;
            }
            String content = formatter.formatCellValue(cell);
            if (content == null) {
                return;
            }
            content = this.trim.apply(content);
            this.readContext.reset(obj, fieldDefinition.getField(), content, row.getRowNum(), (int)index);
            ReadConverterContext.convert(obj, this.readContext);
        });
        return obj;
    }

    private void convertPicture(Row row, T obj, Integer index, Field field) {
        byte[] pictureData;
        if (this.isXSSFSheet) {
            XSSFPicture xssfPicture = this.xssfPicturesMap.get(row.getRowNum() + "_" + index);
            if (xssfPicture == null) {
                return;
            }
            pictureData = xssfPicture.getPictureData().getData();
        } else {
            HSSFPicture hssfPicture = this.hssfPictureMap.get(row.getRowNum() + "_" + index);
            if (hssfPicture == null) {
                return;
            }
            pictureData = hssfPicture.getPictureData().getData();
        }
        try {
            field.set(obj, new ByteArrayInputStream(pictureData));
        }
        catch (IllegalAccessException e) {
            throw new ExcelReadException("Failed to read picture.", e);
        }
    }
}

