/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.templatehandler;

import com.github.liaochong.myexcel.core.templatehandler.AbstractTemplateHandler;
import java.io.File;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateHandler
extends AbstractTemplateHandler<TemplateEngine, TemplateEngine> {
    private static final Map<String, TemplateEngine> CFG_MAP = new HashMap<String, TemplateEngine>();
    private String filePath;

    @Override
    public ThymeleafTemplateHandler classpathTemplate(String path) {
        if (!path.endsWith(".html")) {
            throw new IllegalArgumentException("ThymeleafExcelBuilder only supports files suffixed with .html");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.filePath = path;
        this.setTemplateEngine("classpath", (Supplier<TemplateEngine>)null, (String)null);
        return this;
    }

    @Override
    public ThymeleafTemplateHandler fileTemplate(String dirPath, String fileName) {
        if (!fileName.endsWith(".html")) {
            throw new IllegalArgumentException("ThymeleafExcelBuilder only supports files suffixed with .html");
        }
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + File.separator;
        }
        this.filePath = fileName;
        this.setTemplateEngine(dirPath, (Supplier<TemplateEngine>)null, (String)null);
        return this;
    }

    @Override
    protected void setTemplateEngine(String dirPath, Supplier<TemplateEngine> supplier, String fileName) {
        this.templateEngine = CFG_MAP.getOrDefault(dirPath, this.getTemplateEngineSupplier(dirPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TemplateEngine getTemplateEngineSupplier(String dirPath) {
        Class<ThymeleafTemplateHandler> clazz = ThymeleafTemplateHandler.class;
        synchronized (ThymeleafTemplateHandler.class) {
            TemplateEngine templateEngine = CFG_MAP.get(dirPath);
            if (templateEngine != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return templateEngine;
            }
            templateEngine = new TemplateEngine();
            if (Objects.equals(dirPath, "classpath")) {
                ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
                templateResolver.setCacheable(true);
                templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
                templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
            } else {
                FileTemplateResolver templateResolver = new FileTemplateResolver();
                templateResolver.setPrefix(dirPath);
                templateResolver.setCacheable(false);
                templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
                templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
            }
            CFG_MAP.put(dirPath, templateEngine);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return templateEngine;
        }
    }

    @Override
    protected <F> void render(Map<String, F> renderData, Writer out) throws Exception {
        Context context = new Context();
        context.setVariables(renderData);
        ((TemplateEngine)this.templateEngine).process(this.filePath, (IContext)context, out);
    }
}

