/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.templatehandler;

import com.github.liaochong.myexcel.core.templatehandler.AbstractTemplateHandler;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleDate;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class FreemarkerTemplateHandler
extends AbstractTemplateHandler<Configuration, Template> {
    protected static final Map<String, Configuration> CFG_MAP = new HashMap<String, Configuration>();

    @Override
    protected void setTemplateEngine(String dirPath, Supplier<Configuration> supplier, String fileName) {
        Configuration configuration = CFG_MAP.getOrDefault(dirPath, supplier.get());
        try {
            this.templateEngine = configuration.getTemplate(fileName);
        }
        catch (IOException e) {
            throw ExcelBuildException.of("Failed to get freemarker template", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Configuration getTemplateEngineSupplier(String dirPath) {
        Class<FreemarkerTemplateHandler> clazz = FreemarkerTemplateHandler.class;
        synchronized (FreemarkerTemplateHandler.class) {
            Configuration configuration = CFG_MAP.get(dirPath);
            if (configuration != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return configuration;
            }
            configuration = new Configuration(Configuration.VERSION_2_3_23);
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            configuration.setDefaultEncoding("UTF-8");
            try {
                if (Objects.equals(dirPath, "classpath")) {
                    configuration.setClassLoaderForTemplateLoading(Thread.currentThread().getContextClassLoader(), "/");
                } else {
                    configuration.setDirectoryForTemplateLoading(new File(dirPath));
                }
            }
            catch (IOException e) {
                throw new ExcelBuildException("Set Freemarker directory failure", e);
            }
            this.setObjectWrapper(configuration);
            CFG_MAP.put(dirPath, configuration);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return configuration;
        }
    }

    private void setObjectWrapper(Configuration configuration) {
        configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_23){

            public TemplateModel wrap(Object object) throws TemplateModelException {
                if (object instanceof LocalDate) {
                    return new SimpleDate(Date.valueOf((LocalDate)object));
                }
                if (object instanceof LocalTime) {
                    return new SimpleDate(Time.valueOf((LocalTime)object));
                }
                if (object instanceof LocalDateTime) {
                    return new SimpleDate(Timestamp.valueOf((LocalDateTime)object));
                }
                return super.wrap(object);
            }
        });
    }

    @Override
    protected <E> void render(Map<String, E> renderData, Writer out) throws Exception {
        ((Template)this.templateEngine).process(renderData, out);
    }
}

