/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.style;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;

public final class BorderStyle {
    public static final String BORDER_LEFT_STYLE = "border-left-style";
    public static final String BORDER_RIGHT_STYLE = "border-right-style";
    public static final String BORDER_TOP_STYLE = "border-top-style";
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    public static final String THIN = "thin";
    private static Map<String, org.apache.poi.ss.usermodel.BorderStyle> borderStyleMap = Arrays.stream(org.apache.poi.ss.usermodel.BorderStyle.values()).collect(Collectors.toMap(b -> b.toString().toLowerCase(), b -> b));

    public static void setBorder(CellStyle cellStyle, Map<String, String> tdStyle) {
        String borderBottomStyle;
        String borderTopStyle;
        String borderRightStyle;
        if (Objects.isNull(tdStyle)) {
            return;
        }
        String borderLeftStyle = tdStyle.get(BORDER_LEFT_STYLE);
        if (borderStyleMap.containsKey(borderLeftStyle)) {
            cellStyle.setBorderLeft(borderStyleMap.get(borderLeftStyle));
        }
        if (borderStyleMap.containsKey(borderRightStyle = tdStyle.get(BORDER_RIGHT_STYLE))) {
            cellStyle.setBorderRight(borderStyleMap.get(borderRightStyle));
        }
        if (borderStyleMap.containsKey(borderTopStyle = tdStyle.get(BORDER_TOP_STYLE))) {
            cellStyle.setBorderTop(borderStyleMap.get(borderTopStyle));
        }
        if (borderStyleMap.containsKey(borderBottomStyle = tdStyle.get(BORDER_BOTTOM_STYLE))) {
            cellStyle.setBorderBottom(borderStyleMap.get(borderBottomStyle));
        }
    }
}

