/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class LocalDateReadConverter
extends AbstractReadConverter<LocalDate> {
    @Override
    public LocalDate doConvert(String v, Field field) {
        if (this.isNumber(v)) {
            long time = Long.parseLong(v);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(time), TimeZone.getDefault().toZoneId());
            return localDateTime.toLocalDate();
        }
        DateTimeFormatter dateTimeFormatter = this.getDateFormatFormatter(field);
        return LocalDate.parse(v, dateTimeFormatter);
    }
}

