/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelStreamFactory;
import com.github.liaochong.myexcel.core.SimpleStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;

public class DefaultStreamExcelBuilder
extends AbstractSimpleExcelBuilder
implements SimpleStreamExcelBuilder {
    private ExecutorService executorService;
    private HtmlToExcelStreamFactory htmlToExcelStreamFactory;
    private Workbook workbook;
    private int capacity;
    private Consumer<Path> pathConsumer;

    private DefaultStreamExcelBuilder() {
        this.noStyle = true;
        this.autoWidthStrategy = AutoWidthStrategy.NO_AUTO;
        this.workbookType = WorkbookType.SXLSX;
    }

    public static DefaultStreamExcelBuilder of(@NonNull Class<?> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = new DefaultStreamExcelBuilder();
        defaultStreamExcelBuilder.dataType = dataType;
        return defaultStreamExcelBuilder;
    }

    public static DefaultStreamExcelBuilder of(@NonNull Class<?> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = new DefaultStreamExcelBuilder();
        defaultStreamExcelBuilder.dataType = dataType;
        defaultStreamExcelBuilder.workbook = workbook;
        return defaultStreamExcelBuilder;
    }

    public static DefaultStreamExcelBuilder getInstance() {
        return new DefaultStreamExcelBuilder();
    }

    @Override
    public DefaultStreamExcelBuilder rowAccessWindowSize(int rowAccessWindowSize) {
        super.rowAccessWindowSize(rowAccessWindowSize);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        super.workbookType(workbookType);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder threadPool(@NonNull ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        this.executorService = executorService;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        super.sheetName(sheetName);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder hasStyle() {
        this.noStyle = false;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        super.autoWidthStrategy(autoWidthStrategy);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.titles = titles;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder fixedTitles() {
        this.fixedTitles = true;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder capacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this.capacity = capacity;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder pathConsumer(Consumer<Path> pathConsumer) {
        this.pathConsumer = pathConsumer;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder widths(int ... widths) {
        super.widths(widths);
        return this;
    }

    public DefaultStreamExcelBuilder start(Class<?> ... groups) {
        this.start(HtmlToExcelStreamFactory.DEFAULT_WAIT_SIZE, (Class[])groups);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder start(int waitQueueSize, Class<?> ... groups) {
        this.htmlToExcelStreamFactory = new HtmlToExcelStreamFactory(waitQueueSize, this.executorService, this.pathConsumer, this.capacity);
        this.htmlToExcelStreamFactory.rowAccessWindowSize(this.rowAccessWindowSize).workbookType(this.workbookType).autoWidthStrategy(this.autoWidthStrategy);
        if (this.dataType != null) {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.dataType);
            this.filteredFields = this.getFilteredFields(classFieldContainer, groups);
        }
        this.initStyleMap();
        Table table = this.createTable();
        this.htmlToExcelStreamFactory.start(table, this.workbook);
        List<Tr> head = this.createThead();
        if (Objects.isNull(head)) {
            return this;
        }
        this.htmlToExcelStreamFactory.appendTitles(head);
        return this;
    }

    @Override
    public void append(List<?> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        boolean isMapBuild = data.stream().anyMatch(d -> d instanceof Map);
        if (isMapBuild) {
            for (Object datum : data) {
                Map d2 = (Map)datum;
                ArrayList contents = new ArrayList(d2.size());
                for (String fieldName : this.fieldDisplayOrder) {
                    Object val = d2.get(fieldName);
                    contents.add(Pair.of(val == null ? String.class : val.getClass(), val));
                }
                Tr tr = this.createTr(contents, 0, 0);
                this.htmlToExcelStreamFactory.append(tr);
            }
        } else {
            for (Object datum : data) {
                List<Pair<? extends Class, ?>> contents = this.getRenderContent(datum, (List<Field>)this.filteredFields);
                Tr tr = this.createTr(contents, 0, 0);
                this.htmlToExcelStreamFactory.append(tr);
            }
        }
    }

    @Override
    public <T> void append(T data) {
        List<Pair<Class, ?>> contents;
        if (data == null) {
            return;
        }
        if (data instanceof Map) {
            Map d = (Map)data;
            contents = new ArrayList(d.size());
            for (String fieldName : this.fieldDisplayOrder) {
                Object val = d.get(fieldName);
                contents.add(Pair.of(val == null ? String.class : val.getClass(), val));
            }
        } else {
            contents = this.getRenderContent(data, (List<Field>)this.filteredFields);
        }
        Tr tr = this.createTr(contents, 0, 0);
        this.htmlToExcelStreamFactory.append(tr);
    }

    @Override
    public Workbook build() {
        if (this.fixedTitles && this.titleLevel > 0) {
            FreezePane freezePane = new FreezePane(this.titleLevel, 0);
            this.htmlToExcelStreamFactory.freezePanes(freezePane);
        }
        return this.htmlToExcelStreamFactory.build();
    }

    @Override
    public List<Path> buildAsPaths() {
        return this.htmlToExcelStreamFactory.buildAsPaths();
    }

    @Override
    public Path buildAsZip(String fileName) {
        return this.htmlToExcelStreamFactory.buildAsZip(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelStreamFactory != null) {
            this.htmlToExcelStreamFactory.closeWorkbook();
        }
    }

    @Override
    public Workbook build(List<?> data, Class<?> ... groups) {
        throw new UnsupportedOperationException();
    }
}

