/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Csv;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcelTable;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.container.ParallelContainer;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CsvBuilder<T> {
    private static final Pattern PATTERN_COMMA = Pattern.compile(",+");
    private static final Pattern PATTERN_QUOTES = Pattern.compile("\"");
    private Class<T> type;
    private String globalDefaultValue;
    private Map<Field, String> defaultValueMap;
    private List<String> titles;
    private boolean isAppend = true;

    private CsvBuilder(Class<T> type) {
        this.type = type;
    }

    public static <T> CsvBuilder<T> of(Class<T> clazz) {
        return new CsvBuilder<T>(clazz);
    }

    public Csv build(List<T> beans, Class<?> ... groups) {
        this.isAppend = false;
        Path path = TempFileOperator.createTempFile("d_t_c", ".csv");
        return this.build(beans, new Csv(path), groups);
    }

    public Csv build(List<T> beans, Csv csv, Class<?> ... groups) {
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.type);
        List<Field> fields = this.getFields(classFieldContainer, groups);
        if (beans == null || beans.isEmpty()) {
            return csv;
        }
        List<List<?>> contents = this.getRenderContent((T)beans, fields);
        this.writeToCsv(contents, csv);
        return csv;
    }

    private List<Field> getFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ExcelTable excelTable = classFieldContainer.getClazz().getAnnotation(ExcelTable.class);
        boolean excelTableExist = Objects.nonNull(excelTable);
        boolean excludeParent = false;
        boolean includeAllField = false;
        boolean ignoreStaticFields = true;
        if (excelTableExist) {
            excludeParent = excelTable.excludeParent();
            includeAllField = excelTable.includeAllField();
            if (!excelTable.defaultValue().isEmpty()) {
                this.globalDefaultValue = excelTable.defaultValue();
            }
            ignoreStaticFields = excelTable.ignoreStaticFields();
        }
        List<Field> preElectionFields = this.getPreElectionFields(classFieldContainer, excludeParent, includeAllField);
        if (ignoreStaticFields) {
            preElectionFields = preElectionFields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        }
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        boolean useFieldNameAsTitle = excelTableExist && excelTable.useFieldNameAsTitle();
        ArrayList<String> titles = new ArrayList<String>(preElectionFields.size());
        List<Field> sortedFields = preElectionFields.stream().filter(field -> !field.isAnnotationPresent(ExcludeColumn.class) && this.filterFields(selectedGroupList, (Field)field)).sorted(this::sortFields).collect(Collectors.toList());
        this.defaultValueMap = new HashMap<Field, String>(preElectionFields.size());
        boolean needToAddTitle = this.titles == null;
        int size = sortedFields.size();
        for (int i = 0; i < size; ++i) {
            Field field2 = (Field)sortedFields.get(i);
            ExcelColumn excelColumn = field2.getAnnotation(ExcelColumn.class);
            if (excelColumn != null) {
                if (needToAddTitle) {
                    if (useFieldNameAsTitle && excelColumn.title().isEmpty()) {
                        titles.add(field2.getName());
                    } else {
                        titles.add(excelColumn.title());
                    }
                }
                if (excelColumn.defaultValue().isEmpty()) continue;
                this.defaultValueMap.put(field2, excelColumn.defaultValue());
                continue;
            }
            if (!needToAddTitle) continue;
            if (useFieldNameAsTitle) {
                titles.add(field2.getName());
                continue;
            }
            titles.add(null);
        }
        boolean hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank);
        if (hasTitle) {
            this.titles = titles;
        }
        return sortedFields;
    }

    private List<Field> getPreElectionFields(ClassFieldContainer classFieldContainer, boolean excludeParent, boolean includeAllField) {
        if (includeAllField) {
            if (excludeParent) {
                return classFieldContainer.getDeclaredFields();
            }
            return classFieldContainer.getFields();
        }
        if (excludeParent) {
            return classFieldContainer.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(ExcelColumn.class)).collect(Collectors.toList());
        }
        return classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
    }

    private boolean filterFields(List<Class<?>> selectedGroupList, Field field) {
        if (selectedGroupList.isEmpty()) {
            return true;
        }
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        if (excelColumn == null) {
            return false;
        }
        Class<?>[] groupArr = excelColumn.groups();
        if (groupArr.length == 0) {
            return false;
        }
        List reservedGroupList = Arrays.stream(groupArr).collect(Collectors.toList());
        return reservedGroupList.stream().anyMatch(selectedGroupList::contains);
    }

    private int sortFields(Field field1, Field field2) {
        int defaultOrder;
        ExcelColumn excelColumn1 = field1.getAnnotation(ExcelColumn.class);
        ExcelColumn excelColumn2 = field2.getAnnotation(ExcelColumn.class);
        if (excelColumn1 == null && excelColumn2 == null) {
            return 0;
        }
        int order1 = defaultOrder = 0;
        if (excelColumn1 != null) {
            order1 = excelColumn1.order();
        }
        int order2 = defaultOrder;
        if (excelColumn2 != null) {
            order2 = excelColumn2.order();
        }
        if (order1 == order2) {
            return 0;
        }
        return order1 > order2 ? 1 : -1;
    }

    private List<List<?>> getRenderContent(List<T> data, List<Field> sortedFields) {
        List resolvedDataContainers = IntStream.range(0, data.size()).parallel().mapToObj(index -> {
            List<?> resolvedDataList = this.getRenderContent(data.get(index), sortedFields);
            return new ParallelContainer(index, resolvedDataList);
        }).collect(Collectors.toCollection(LinkedList::new));
        data.clear();
        return resolvedDataContainers.stream().sorted(Comparator.comparing(ParallelContainer::getIndex)).map(ParallelContainer::getData).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<?> getRenderContent(T data, List<Field> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(field.getType(), defaultValue);
            }
            if (this.globalDefaultValue != null) {
                return Pair.of(field.getType(), this.globalDefaultValue);
            }
            return value;
        }).map(Pair::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    private void writeToCsv(List<List<?>> data, Csv csv) {
        if (!this.isAppend && this.titles != null) {
            data.add(0, this.titles);
        }
        List content = data.stream().map(d -> d.stream().map(v -> {
            if (v == null) {
                return "\"\"";
            }
            String vStr = v.toString();
            vStr = PATTERN_QUOTES.matcher(vStr).replaceAll("\"\"");
            boolean hasComma = PATTERN_COMMA.matcher(v.toString()).find();
            if (hasComma) {
                vStr = "\"" + vStr + "\"";
            }
            return vStr;
        }).collect(Collectors.joining(","))).collect(Collectors.toCollection(LinkedList::new));
        try {
            Files.write(csv.getFilePath(), (Iterable<? extends CharSequence>)content, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

