/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelFactory;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.HtmlTableParser;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.style.BackgroundStyle;
import com.github.liaochong.myexcel.core.style.BorderStyle;
import com.github.liaochong.myexcel.core.style.CustomColor;
import com.github.liaochong.myexcel.core.style.FontStyle;
import com.github.liaochong.myexcel.core.style.LinkDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.TdDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.TextAlignStyle;
import com.github.liaochong.myexcel.core.style.ThDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.WordBreakStyle;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractExcelFactory
implements ExcelFactory {
    protected Workbook workbook;
    private Map<Integer, Short> maxTdHeightMap = new HashMap<Integer, Short>();
    private boolean useDefaultStyle;
    private CustomColor customColor;
    private Map<Map<String, String>, CellStyle> cellStyleMap = new HashMap<Map<String, String>, CellStyle>();
    private Map<HtmlTableParser.TableTag, CellStyle> defaultCellStyleMap;
    private Map<String, Font> fontMap = new HashMap<String, Font>();
    private FreezePane[] freezePanes;
    private Integer rowAccessWindowSize = 1;
    protected AutoWidthStrategy autoWidthStrategy = AutoWidthStrategy.CUSTOM_WIDTH;
    private List<Td> stagingTds = new LinkedList<Td>();
    private CreationHelper createHelper;

    @Override
    public ExcelFactory useDefaultStyle() {
        this.useDefaultStyle = true;
        return this;
    }

    @Override
    public ExcelFactory freezePanes(FreezePane ... freezePanes) {
        this.freezePanes = freezePanes;
        return this;
    }

    @Override
    public ExcelFactory rowAccessWindowSize(int rowAccessWindowSize) {
        if (rowAccessWindowSize <= 0) {
            return this;
        }
        this.rowAccessWindowSize = rowAccessWindowSize;
        return this;
    }

    @Override
    public ExcelFactory workbookType(WorkbookType workbookType) {
        if (Objects.nonNull(this.workbook)) {
            return this;
        }
        switch (workbookType) {
            case XLS: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case XLSX: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            case SXLSX: {
                this.workbook = new SXSSFWorkbook(this.rowAccessWindowSize.intValue());
                break;
            }
            default: {
                this.workbook = new XSSFWorkbook();
            }
        }
        return this;
    }

    @Override
    public ExcelFactory autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.autoWidthStrategy = autoWidthStrategy;
        return this;
    }

    protected void createRow(Tr tr, Sheet sheet) {
        Row row = sheet.createRow(tr.getIndex());
        if (!tr.isVisibility()) {
            row.setZeroHeight(true);
        }
        this.stagingTds.stream().filter(blankTd -> Objects.equals(blankTd.getRow(), tr.getIndex())).forEach(td -> {
            if (tr.getTdList() == Collections.EMPTY_LIST) {
                tr.setTdList(new LinkedList<Td>());
            }
            tr.getTdList().add((Td)td);
        });
        for (Td td2 : tr.getTdList()) {
            this.createCell(td2, sheet, row);
            if (td2.getRowSpan() == 0) continue;
            int rowBound = td2.getRowBound();
            for (int i = td2.getRow() + 1; i <= rowBound; ++i) {
                int colBound = td2.getColBound();
                for (int j = td2.getCol(); j <= colBound; ++j) {
                    Td blankTd2 = new Td(i, j);
                    blankTd2.setTh(td2.isTh());
                    blankTd2.setStyle(td2.getStyle());
                    this.stagingTds.add(blankTd2);
                }
            }
        }
        this.stagingTds.removeIf(td -> Objects.equals(td.getRow(), tr.getIndex()));
        if (this.maxTdHeightMap.get(row.getRowNum()) == null) {
            row.setHeightInPoints(row.getHeightInPoints() + 5.0f);
        } else {
            row.setHeightInPoints((float)((short)(this.maxTdHeightMap.get(row.getRowNum()) + 5)));
            this.maxTdHeightMap.remove(row.getRowNum());
        }
    }

    protected void createCell(Td td, Sheet sheet, Row currentRow) {
        Cell cell;
        if (td.isFormula()) {
            cell = currentRow.createCell(td.getCol(), CellType.FORMULA);
            cell.setCellFormula(td.getContent());
        } else {
            String content = td.getContent();
            switch (td.getTdContentType()) {
                case STRING: {
                    cell = currentRow.createCell(td.getCol(), CellType.STRING);
                    cell.setCellValue(content);
                    break;
                }
                case DOUBLE: {
                    cell = currentRow.createCell(td.getCol(), CellType.NUMERIC);
                    if (null == content) break;
                    cell.setCellValue(Double.parseDouble(content));
                    break;
                }
                case BOOLEAN: {
                    cell = currentRow.createCell(td.getCol(), CellType.BOOLEAN);
                    if (null == content) break;
                    cell.setCellValue(Boolean.parseBoolean(content));
                    break;
                }
                case NUMBER_DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.getCol(), CellType.NUMERIC);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(Double.parseDouble(firstEle));
                    break;
                }
                case BOOLEAN_DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.getCol(), CellType.BOOLEAN);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(Boolean.parseBoolean(firstEle));
                    break;
                }
                case DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.getCol(), CellType.STRING);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(firstEle);
                    break;
                }
                case LINK_URL: {
                    cell = this.setLink(td, currentRow, HyperlinkType.URL);
                    break;
                }
                case LINK_EMAIL: {
                    cell = this.setLink(td, currentRow, HyperlinkType.EMAIL);
                    break;
                }
                default: {
                    cell = currentRow.createCell(td.getCol(), CellType.STRING);
                    cell.setCellValue(content);
                }
            }
        }
        this.setCellStyle(currentRow, cell, td);
        if (td.getCol() != td.getColBound()) {
            int colBound = td.getColBound();
            for (int j = td.getCol() + 1; j <= colBound; ++j) {
                cell = currentRow.createCell(j);
                this.setCellStyle(currentRow, cell, td);
            }
        }
        if (td.getColSpan() > 0 || td.getRowSpan() > 0) {
            sheet.addMergedRegion(new CellRangeAddress(td.getRow(), td.getRowBound(), td.getCol(), td.getColBound()));
        }
    }

    private Cell setLink(Td td, Row currentRow, HyperlinkType hyperlinkType) {
        if (StringUtil.isBlank(td.getContent())) {
            return currentRow.createCell(td.getCol());
        }
        if (this.createHelper == null) {
            this.createHelper = this.workbook.getCreationHelper();
        }
        Cell cell = currentRow.createCell(td.getCol(), CellType.STRING);
        cell.setCellValue(td.getContent());
        Hyperlink link = this.createHelper.createHyperlink(hyperlinkType);
        link.setAddress(td.getLink());
        cell.setHyperlink(link);
        return cell;
    }

    private String setDropDownList(Td td, Sheet sheet, String content) {
        String[] list;
        DataValidationConstraint dvConstraint;
        CellRangeAddressList addressList = new CellRangeAddressList(td.getRow(), td.getRowBound(), td.getCol(), td.getColBound());
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidation validation = dvHelper.createValidation(dvConstraint = dvHelper.createExplicitListConstraint(list = content.split(",")), addressList);
        if (validation instanceof XSSFDataValidation) {
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        } else {
            validation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(validation);
        if (list.length > 0) {
            return list[0];
        }
        return null;
    }

    private void setCellStyle(Row row, Cell cell, Td td) {
        if (this.useDefaultStyle) {
            if (td.isTh()) {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.TableTag.th));
            } else if (ContentTypeEnum.isLink(td.getTdContentType())) {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.TableTag.link));
            } else {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.TableTag.td));
            }
        } else {
            short fontSize;
            if (td.getStyle().isEmpty()) {
                return;
            }
            String fs = td.getStyle().get("font-size");
            if (fs != null && (fontSize = Short.parseShort(fs = fs.replaceAll("\\D*", ""))) > this.maxTdHeightMap.getOrDefault(row.getRowNum(), (short)12)) {
                this.maxTdHeightMap.put(row.getRowNum(), fontSize);
            }
            if (this.cellStyleMap.containsKey(td.getStyle())) {
                cell.setCellStyle(this.cellStyleMap.get(td.getStyle()));
                return;
            }
            CellStyle cellStyle = this.workbook.createCellStyle();
            BackgroundStyle.setBackgroundColor(cellStyle, td.getStyle(), this.customColor);
            TextAlignStyle.setTextAlign(cellStyle, td.getStyle());
            BorderStyle.setBorder(cellStyle, td.getStyle());
            FontStyle.setFont(() -> this.workbook.createFont(), cellStyle, td.getStyle(), this.fontMap, this.customColor);
            WordBreakStyle.setWordBreak(cellStyle, td.getStyle());
            cell.setCellStyle(cellStyle);
            this.cellStyleMap.put(td.getStyle(), cellStyle);
        }
    }

    protected Workbook emptyWorkbook() {
        if (this.workbook == null) {
            this.workbook = new XSSFWorkbook();
        }
        this.workbook.createSheet();
        return this.workbook;
    }

    protected void initCellStyle(Workbook workbook) {
        if (this.useDefaultStyle) {
            this.defaultCellStyleMap = new EnumMap<HtmlTableParser.TableTag, CellStyle>(HtmlTableParser.TableTag.class);
            this.defaultCellStyleMap.put(HtmlTableParser.TableTag.th, new ThDefaultCellStyle().supply(workbook));
            this.defaultCellStyleMap.put(HtmlTableParser.TableTag.td, new TdDefaultCellStyle().supply(workbook));
            this.defaultCellStyleMap.put(HtmlTableParser.TableTag.link, new LinkDefaultCellStyle().supply(workbook));
        } else if (workbook instanceof HSSFWorkbook) {
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            this.customColor = new CustomColor(true, palette);
        } else {
            this.customColor = new CustomColor();
        }
    }

    protected void freezePane(int tableIndex, Sheet sheet) {
        if (this.freezePanes != null && this.freezePanes.length > tableIndex) {
            FreezePane freezePane = this.freezePanes[tableIndex];
            if (freezePane == null) {
                throw new IllegalStateException("FreezePane is null");
            }
            sheet.createFreezePane(freezePane.getColSplit(), freezePane.getRowSplit());
        }
    }

    protected Map<Integer, Integer> getColMaxWidthMap(List<Tr> trList) {
        if (AutoWidthStrategy.isNoAuto(this.autoWidthStrategy) || AutoWidthStrategy.isAutoWidth(this.autoWidthStrategy)) {
            return Collections.emptyMap();
        }
        if (this.useDefaultStyle) {
            trList.parallelStream().forEach(tr -> tr.getTdList().stream().filter(Td::isTh).forEach(th -> {
                int tdWidth = TdUtil.getStringWidth(th.getContent(), 0.25);
                tr.getColWidthMap().put(th.getCol(), tdWidth);
            }));
        }
        int mapMaxSize = trList.stream().mapToInt(tr -> tr.getColWidthMap().size()).max().orElse(16);
        HashMap<Integer, Integer> colMaxWidthMap = new HashMap<Integer, Integer>(mapMaxSize);
        trList.forEach(tr -> {
            tr.getColWidthMap().forEach((k, v) -> {
                Integer width = (Integer)colMaxWidthMap.get(k);
                if (Objects.isNull(width) || v > width) {
                    colMaxWidthMap.put((Integer)k, (Integer)v);
                }
            });
            tr.setColWidthMap(null);
        });
        return colMaxWidthMap;
    }

    protected void setColWidth(Map<Integer, Integer> colMaxWidthMap, Sheet sheet, int maxColIndex) {
        if (AutoWidthStrategy.isNoAuto(this.autoWidthStrategy)) {
            return;
        }
        if (AutoWidthStrategy.isAutoWidth(this.autoWidthStrategy)) {
            if (sheet instanceof SXSSFSheet) {
                throw new UnsupportedOperationException("SXSSF does not support automatic width at this time");
            }
            for (int i = 0; i <= maxColIndex; ++i) {
                sheet.autoSizeColumn(i);
            }
            return;
        }
        colMaxWidthMap.forEach((key, value) -> {
            int contentLength = value << 1;
            if (contentLength > 255) {
                contentLength = 255;
            }
            sheet.setColumnWidth(key.intValue(), contentLength << 8);
        });
    }

    protected void clearCache() {
        this.cellStyleMap = new HashMap<Map<String, String>, CellStyle>();
        this.fontMap = new HashMap<String, Font>();
        this.maxTdHeightMap = new HashMap<Integer, Short>();
    }

    protected void closeWorkbook() {
        if (this.workbook == null) {
            return;
        }
        try {
            if (this.workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
            this.workbook.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

