/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelFactory;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelBuilder
implements ExcelBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelBuilder.class);
    protected HtmlToExcelFactory htmlToExcelFactory = new HtmlToExcelFactory();

    @Override
    public AbstractExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        this.htmlToExcelFactory.workbookType(workbookType);
        if (WorkbookType.isSxlsx(workbookType)) {
            this.autoWidthStrategy(AutoWidthStrategy.NO_AUTO);
        }
        return this;
    }

    @Override
    public AbstractExcelBuilder rowAccessWindowSize(int rowAccessWindowSize) {
        this.htmlToExcelFactory.rowAccessWindowSize(rowAccessWindowSize);
        return this;
    }

    @Override
    public AbstractExcelBuilder useDefaultStyle() {
        this.htmlToExcelFactory.useDefaultStyle();
        return this;
    }

    @Override
    public AbstractExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.htmlToExcelFactory.autoWidthStrategy(autoWidthStrategy);
        return this;
    }

    @Override
    public AbstractExcelBuilder freezePanes(FreezePane ... freezePanes) {
        if (freezePanes == null || freezePanes.length == 0) {
            return this;
        }
        this.htmlToExcelFactory.freezePanes(freezePanes);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Workbook build(Map<String, T> data) {
        try (StringWriter out = new StringWriter();){
            this.render(data, out);
            Workbook workbook = HtmlToExcelFactory.readHtml(((Object)out).toString(), this.htmlToExcelFactory).build();
            return workbook;
        }
        catch (Exception e) {
            throw ExcelBuildException.of("Failed to build excel", e);
        }
    }

    protected abstract <T> void render(Map<String, T> var1, Writer var2) throws Exception;

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelFactory != null) {
            this.htmlToExcelFactory.closeWorkbook();
        }
    }
}

