/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public class TranslateAnimator
extends PopupAnimator {
    private float startTranslationX;
    private float startTranslationY;
    private int oldWidth;
    private int oldHeight;
    private float initTranslationX;
    private float initTranslationY;
    public boolean hasInitDefTranslation = false;

    public TranslateAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        if (!this.hasInitDefTranslation) {
            this.initTranslationX = this.targetView.getTranslationX();
            this.initTranslationY = this.targetView.getTranslationY();
            this.hasInitDefTranslation = true;
        }
        this.applyTranslation();
        this.startTranslationX = this.targetView.getTranslationX();
        this.startTranslationY = this.targetView.getTranslationY();
        this.oldWidth = this.targetView.getMeasuredWidth();
        this.oldHeight = this.targetView.getMeasuredHeight();
    }

    private void applyTranslation() {
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getRight()));
                break;
            }
            case TranslateFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getBottom()));
                break;
            }
            case TranslateFromRight: {
                this.targetView.setTranslationX((float)(((View)this.targetView.getParent()).getMeasuredWidth() - this.targetView.getLeft()));
                break;
            }
            case TranslateFromBottom: {
                this.targetView.setTranslationY((float)(((View)this.targetView.getParent()).getMeasuredHeight() - this.targetView.getTop()));
            }
        }
    }

    @Override
    public void animateShow() {
        ViewPropertyAnimator animator = null;
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getRight()));
                animator = this.targetView.animate().translationX(this.initTranslationX);
                break;
            }
            case TranslateFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getBottom()));
                animator = this.targetView.animate().translationY(this.initTranslationY);
                break;
            }
            case TranslateFromRight: {
                this.targetView.setTranslationX((float)(((View)this.targetView.getParent()).getMeasuredWidth() - this.targetView.getLeft()));
                animator = this.targetView.animate().translationX(this.initTranslationX);
                break;
            }
            case TranslateFromBottom: {
                this.targetView.setTranslationY((float)(((View)this.targetView.getParent()).getMeasuredHeight() - this.targetView.getTop()));
                animator = this.targetView.animate().translationY(this.initTranslationY);
            }
        }
        if (animator != null) {
            animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)XPopup.getAnimationDuration()).withLayer().start();
        }
    }

    @Override
    public void animateDismiss() {
        ViewPropertyAnimator animator = null;
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.startTranslationX -= (float)(this.targetView.getMeasuredWidth() - this.oldWidth);
                animator = this.targetView.animate().translationX(this.startTranslationX);
                break;
            }
            case TranslateFromTop: {
                this.startTranslationY -= (float)(this.targetView.getMeasuredHeight() - this.oldHeight);
                animator = this.targetView.animate().translationY(this.startTranslationY);
                break;
            }
            case TranslateFromRight: {
                this.startTranslationX += (float)(this.targetView.getMeasuredWidth() - this.oldWidth);
                animator = this.targetView.animate().translationX(this.startTranslationX);
                break;
            }
            case TranslateFromBottom: {
                this.startTranslationY += (float)(this.targetView.getMeasuredHeight() - this.oldHeight);
                animator = this.targetView.animate().translationY(this.startTranslationY);
            }
        }
        if (animator != null) {
            animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)XPopup.getAnimationDuration()).withLayer().start();
        }
    }
}

