/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnInputConfirmListener;
import com.lxj.xpopup.util.XPopupUtils;

public class InputConfirmPopupView
extends ConfirmPopupView
implements View.OnClickListener {
    public CharSequence inputContent;
    OnCancelListener cancelListener;
    OnInputConfirmListener inputConfirmListener;

    public InputConfirmPopupView(@NonNull Context context, int bindLayoutId) {
        super(context, bindLayoutId);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        XPopupUtils.setVisible((View)this.et_input, true);
        if (!TextUtils.isEmpty((CharSequence)this.hint)) {
            this.et_input.setHint(this.hint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.inputContent)) {
            this.et_input.setText(this.inputContent);
            this.et_input.setSelection(this.inputContent.length());
        }
        XPopupUtils.setCursorDrawableColor(this.et_input, XPopup.getPrimaryColor());
        if (this.bindLayoutId == 0) {
            this.et_input.post(() -> {
                if (this.et_input.getMeasuredWidth() > 0) {
                    BitmapDrawable defaultDrawable = XPopupUtils.createBitmapDrawable(this.getContext(), this.et_input.getMeasuredWidth(), Color.parseColor((String)"#888888"));
                    BitmapDrawable focusDrawable = XPopupUtils.createBitmapDrawable(this.getContext(), this.et_input.getMeasuredWidth(), XPopup.getPrimaryColor());
                    this.et_input.setBackgroundDrawable((Drawable)XPopupUtils.createSelector((Drawable)defaultDrawable, (Drawable)focusDrawable));
                }
            });
        }
    }

    public EditText getEditText() {
        return this.et_input;
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        this.et_input.setHintTextColor(Color.parseColor((String)"#888888"));
        this.et_input.setTextColor(Color.parseColor((String)"#333333"));
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        this.et_input.setHintTextColor(Color.parseColor((String)"#888888"));
        this.et_input.setTextColor(Color.parseColor((String)"#dddddd"));
    }

    public void setListener(OnInputConfirmListener inputConfirmListener, OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
        this.inputConfirmListener = inputConfirmListener;
    }

    @Override
    public void onClick(View v) {
        if (v == this.tv_cancel) {
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
            this.dismiss();
        } else if (v == this.tv_confirm) {
            if (this.inputConfirmListener != null) {
                this.inputConfirmListener.onConfirm(this.et_input.getText().toString().trim());
            }
            if (this.popupInfo.autoDismiss.booleanValue()) {
                this.dismiss();
            }
        }
    }

    @Override
    protected int getMaxWidth() {
        return this.popupInfo.maxWidth == 0 ? super.getMaxWidth() : this.popupInfo.maxWidth;
    }
}

