/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;

public class PositionPopupView
extends BasePopupView {
    FrameLayout positionPopupContainer = (FrameLayout)this.findViewById(R.id.positionPopupContainer);

    public PositionPopupView(@NonNull Context context) {
        super(context);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.positionPopupContainer, false);
        this.positionPopupContainer.addView(contentView);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_position_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                if (PositionPopupView.this.popupInfo == null) {
                    return;
                }
                if (PositionPopupView.this.popupInfo.isCenterHorizontal) {
                    float left = !XPopupUtils.isLayoutRtl(PositionPopupView.this.getContext()) ? (float)(XPopupUtils.getAppWidth(PositionPopupView.this.getContext()) - PositionPopupView.this.positionPopupContainer.getMeasuredWidth()) / 2.0f : (float)(-(XPopupUtils.getAppWidth(PositionPopupView.this.getContext()) - PositionPopupView.this.positionPopupContainer.getMeasuredWidth())) / 2.0f;
                    PositionPopupView.this.positionPopupContainer.setTranslationX(left);
                } else {
                    PositionPopupView.this.positionPopupContainer.setTranslationX((float)PositionPopupView.this.popupInfo.offsetX);
                }
                PositionPopupView.this.positionPopupContainer.setTranslationY((float)PositionPopupView.this.popupInfo.offsetY);
                PositionPopupView.this.initAndStartAnimation();
            }
        });
    }

    protected void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new ScaleAlphaAnimator(this.getPopupContentView(), this.getAnimationDuration(), PopupAnimation.ScaleAlphaFromCenter);
    }
}

