/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public abstract class PopupAnimator {
    protected boolean animating = false;
    public View targetView;
    public int animationDuration = 0;
    public PopupAnimation popupAnimation;

    public PopupAnimator() {
    }

    public PopupAnimator(View target, int animationDuration) {
        this(target, animationDuration, null);
    }

    public PopupAnimator(View target, int animationDuration, PopupAnimation popupAnimation) {
        this.targetView = target;
        this.animationDuration = animationDuration;
        this.popupAnimation = popupAnimation;
    }

    public abstract void initAnimator();

    public abstract void animateShow();

    public abstract void animateDismiss();

    public int getDuration() {
        return this.animationDuration;
    }

    protected ValueAnimator observerAnimator(ValueAnimator animator) {
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                PopupAnimator.this.animating = true;
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PopupAnimator.this.animating = false;
            }
        });
        return animator;
    }

    protected ViewPropertyAnimator observerAnimator(ViewPropertyAnimator animator) {
        animator.setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                PopupAnimator.this.animating = true;
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PopupAnimator.this.animating = false;
            }
        });
        return animator;
    }
}

