/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import androidx.viewpager.widget.ViewPager;
import com.lxj.xpopup.enums.LayoutStatus;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;

public class PopupDrawerLayout
extends FrameLayout {
    LayoutStatus status = null;
    ViewDragHelper dragHelper;
    View placeHolder;
    View mChild;
    public PopupPosition position = PopupPosition.Left;
    public boolean isDrawStatusBarShadow = false;
    float fraction = 0.0f;
    public boolean enableDrag = true;
    float ty;
    boolean hasLayout = false;
    boolean isIntercept = false;
    float x;
    float y;
    float downX;
    float downY;
    boolean isToLeft;
    boolean canChildScrollLeft;
    ViewDragHelper.Callback callback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View view, int i) {
            return !PopupDrawerLayout.this.dragHelper.continueSettling(true) && PopupDrawerLayout.this.status != LayoutStatus.Close;
        }

        public int getViewHorizontalDragRange(@NonNull View child) {
            return 1;
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            if (child == PopupDrawerLayout.this.placeHolder) {
                return left;
            }
            return PopupDrawerLayout.this.fixLeft(left);
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if (changedView == PopupDrawerLayout.this.placeHolder) {
                PopupDrawerLayout.this.placeHolder.layout(0, 0, PopupDrawerLayout.this.placeHolder.getMeasuredWidth(), PopupDrawerLayout.this.placeHolder.getMeasuredHeight());
                int newLeft = PopupDrawerLayout.this.fixLeft(PopupDrawerLayout.this.mChild.getLeft() + dx);
                PopupDrawerLayout.this.mChild.layout(newLeft, PopupDrawerLayout.this.mChild.getTop(), newLeft + PopupDrawerLayout.this.mChild.getMeasuredWidth(), PopupDrawerLayout.this.mChild.getBottom());
                this.calcFraction(newLeft, dx);
            } else {
                this.calcFraction(left, dx);
            }
        }

        private void calcFraction(int left, int dx) {
            if (PopupDrawerLayout.this.position == PopupPosition.Left) {
                PopupDrawerLayout.this.fraction = (float)(left + PopupDrawerLayout.this.mChild.getMeasuredWidth()) * 1.0f / (float)PopupDrawerLayout.this.mChild.getMeasuredWidth();
                if (left == -PopupDrawerLayout.this.mChild.getMeasuredWidth() && PopupDrawerLayout.this.listener != null && PopupDrawerLayout.this.status != LayoutStatus.Close) {
                    PopupDrawerLayout.this.status = LayoutStatus.Close;
                    PopupDrawerLayout.this.listener.onClose();
                }
            } else if (PopupDrawerLayout.this.position == PopupPosition.Right) {
                PopupDrawerLayout.this.fraction = (float)(PopupDrawerLayout.this.getMeasuredWidth() - left) * 1.0f / (float)PopupDrawerLayout.this.mChild.getMeasuredWidth();
                if (left == PopupDrawerLayout.this.getMeasuredWidth() && PopupDrawerLayout.this.listener != null && PopupDrawerLayout.this.status != LayoutStatus.Close) {
                    PopupDrawerLayout.this.status = LayoutStatus.Close;
                    PopupDrawerLayout.this.listener.onClose();
                }
            }
            if (PopupDrawerLayout.this.listener != null) {
                PopupDrawerLayout.this.listener.onDrag(left, PopupDrawerLayout.this.fraction, dx < 0);
                if (PopupDrawerLayout.this.fraction == 1.0f && PopupDrawerLayout.this.status != LayoutStatus.Open) {
                    PopupDrawerLayout.this.status = LayoutStatus.Open;
                    PopupDrawerLayout.this.listener.onOpen();
                }
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            if (releasedChild == PopupDrawerLayout.this.placeHolder && xvel == 0.0f) {
                if (PopupDrawerLayout.this.isDismissOnTouchOutside) {
                    PopupDrawerLayout.this.close();
                }
                return;
            }
            if (releasedChild == PopupDrawerLayout.this.mChild && PopupDrawerLayout.this.isToLeft && !PopupDrawerLayout.this.canChildScrollLeft && xvel < -500.0f) {
                PopupDrawerLayout.this.close();
                return;
            }
            int centerLeft = 0;
            int finalLeft = 0;
            if (PopupDrawerLayout.this.position == PopupPosition.Left) {
                if (xvel < -1000.0f) {
                    finalLeft = -PopupDrawerLayout.this.mChild.getMeasuredWidth();
                } else {
                    centerLeft = -PopupDrawerLayout.this.mChild.getMeasuredWidth() / 2;
                    finalLeft = PopupDrawerLayout.this.mChild.getLeft() < centerLeft ? -PopupDrawerLayout.this.mChild.getMeasuredWidth() : 0;
                }
            } else if (xvel > 1000.0f) {
                finalLeft = PopupDrawerLayout.this.getMeasuredWidth();
            } else {
                centerLeft = PopupDrawerLayout.this.getMeasuredWidth() - PopupDrawerLayout.this.mChild.getMeasuredWidth() / 2;
                finalLeft = releasedChild.getLeft() < centerLeft ? PopupDrawerLayout.this.getMeasuredWidth() - PopupDrawerLayout.this.mChild.getMeasuredWidth() : PopupDrawerLayout.this.getMeasuredWidth();
            }
            PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(PopupDrawerLayout.this.mChild, finalLeft, releasedChild.getTop());
            ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
        }
    };
    public boolean isDismissOnTouchOutside = true;
    private OnCloseListener listener;

    public PopupDrawerLayout(Context context) {
        this(context, null);
    }

    public PopupDrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PopupDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.callback);
    }

    public void setDrawerPosition(PopupPosition position) {
        this.position = position;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.placeHolder = this.getChildAt(0);
        this.mChild = this.getChildAt(1);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.ty = this.getTranslationY();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.placeHolder.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        if (!this.hasLayout) {
            if (this.position == PopupPosition.Left) {
                this.mChild.layout(-this.mChild.getMeasuredWidth(), 0, 0, this.getMeasuredHeight());
            } else {
                this.mChild.layout(this.getMeasuredWidth(), 0, this.getMeasuredWidth() + this.mChild.getMeasuredWidth(), this.getMeasuredHeight());
            }
            this.hasLayout = true;
        } else {
            this.mChild.layout(this.mChild.getLeft(), this.mChild.getTop(), this.mChild.getRight(), this.mChild.getMeasuredHeight());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.enableDrag) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.dragHelper.continueSettling(true) || this.status == LayoutStatus.Close) {
            return true;
        }
        this.isToLeft = ev.getX() < this.x;
        this.x = ev.getX();
        this.y = ev.getY();
        switch (ev.getAction()) {
            case 0: {
                this.downX = ev.getX();
                this.downY = ev.getY();
                break;
            }
            case 2: {
                float dx = Math.abs(this.x - this.downX);
                float dy = Math.abs(this.y - this.downY);
                if (!(dy > dx)) break;
                return false;
            }
            case 1: 
            case 3: {
                this.x = 0.0f;
                this.y = 0.0f;
            }
        }
        this.canChildScrollLeft = this.canScroll((ViewGroup)this, ev.getX(), ev.getY(), 1);
        this.isIntercept = this.dragHelper.shouldInterceptTouchEvent(ev);
        if (this.isToLeft && !this.canChildScrollLeft) {
            return this.isIntercept;
        }
        boolean canChildScrollHorizontal = this.canScroll((ViewGroup)this, ev.getX(), ev.getY());
        if (!canChildScrollHorizontal) {
            return this.isIntercept;
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean canScroll(ViewGroup group, float x, float y, int direction) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            int[] location = new int[2];
            child.getLocationInWindow(location);
            Rect rect = new Rect(location[0], location[1], location[0] + child.getWidth(), location[1] + child.getHeight());
            boolean inRect = XPopupUtils.isInRect(x, y, rect);
            if (!inRect || !(child instanceof ViewGroup)) continue;
            if (child instanceof ViewPager) {
                ViewPager pager = (ViewPager)child;
                if (direction == 0) {
                    return pager.canScrollHorizontally(-1) || pager.canScrollHorizontally(1);
                }
                return pager.canScrollHorizontally(direction);
            }
            if (child instanceof HorizontalScrollView) {
                HorizontalScrollView hsv = (HorizontalScrollView)child;
                if (direction == 0) {
                    return hsv.canScrollHorizontally(-1) || hsv.canScrollHorizontally(1);
                }
                return hsv.canScrollHorizontally(direction);
            }
            return this.canScroll((ViewGroup)child, x, y, direction);
        }
        return false;
    }

    private boolean canScroll(ViewGroup group, float x, float y) {
        return this.canScroll(group, x, y, 0);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.enableDrag) {
            return super.onTouchEvent(event);
        }
        if (this.dragHelper.continueSettling(true)) {
            return true;
        }
        this.dragHelper.processTouchEvent(event);
        return true;
    }

    private int fixLeft(int left) {
        if (this.position == PopupPosition.Left) {
            if (left < -this.mChild.getMeasuredWidth()) {
                left = -this.mChild.getMeasuredWidth();
            }
            if (left > 0) {
                left = 0;
            }
        } else if (this.position == PopupPosition.Right) {
            if (left < this.getMeasuredWidth() - this.mChild.getMeasuredWidth()) {
                left = this.getMeasuredWidth() - this.mChild.getMeasuredWidth();
            }
            if (left > this.getMeasuredWidth()) {
                left = this.getMeasuredWidth();
            }
        }
        return left;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void open() {
        this.post(new Runnable(){

            @Override
            public void run() {
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(PopupDrawerLayout.this.mChild, PopupDrawerLayout.this.position == PopupPosition.Left ? 0 : PopupDrawerLayout.this.mChild.getLeft() - PopupDrawerLayout.this.mChild.getMeasuredWidth(), 0);
                ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
            }
        });
    }

    public void close() {
        this.post(new Runnable(){

            @Override
            public void run() {
                PopupDrawerLayout.this.dragHelper.abort();
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(PopupDrawerLayout.this.mChild, PopupDrawerLayout.this.position == PopupPosition.Left ? -PopupDrawerLayout.this.mChild.getMeasuredWidth() : PopupDrawerLayout.this.getMeasuredWidth(), 0);
                ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
            }
        });
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.listener = listener;
    }

    public static interface OnCloseListener {
        public void onClose();

        public void onOpen();

        public void onDrag(int var1, float var2, boolean var3);
    }
}

