/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.photoview.PhotoView;
import com.lxj.xpopup.util.ImageDownloadTarget;
import com.lxj.xpopup.util.XPopupUtils;
import java.io.File;

public class SmartGlideImageLoader
implements XPopupImageLoader {
    private int errImg;

    public SmartGlideImageLoader() {
    }

    public SmartGlideImageLoader(int errImgRes) {
        this.errImg = errImgRes;
    }

    @Override
    public void loadImage(int position, @NonNull Object url, final @NonNull PhotoView imageView, final @NonNull PhotoView snapshot, final @NonNull SubsamplingScaleImageView bigImageView, final @NonNull ProgressBar progressBar) {
        progressBar.setVisibility(0);
        final Context context = imageView.getContext();
        Glide.with((View)imageView).downloadOnly().load(url).into((Target)new ImageDownloadTarget(){

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                progressBar.setVisibility(8);
                bigImageView.setVisibility(8);
                imageView.setVisibility(0);
                imageView.setImageResource(SmartGlideImageLoader.this.errImg);
                imageView.setZoomable(false);
            }

            @Override
            public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
                int maxW = XPopupUtils.getWindowWidth(context) * 2;
                int maxH = XPopupUtils.getScreenHeight(context) * 2;
                int[] size = XPopupUtils.getImageSize(resource);
                if (size[0] > maxW || size[1] > maxH) {
                    imageView.setVisibility(8);
                    snapshot.setVisibility(0);
                    bigImageView.setVisibility(0);
                    if (size[0] >= size[1]) {
                        bigImageView.setMinimumScaleType(1);
                    } else {
                        bigImageView.setMinimumScaleType(4);
                    }
                    if (snapshot.getDrawable() != null && snapshot.getDrawable() instanceof BitmapDrawable) {
                        BitmapDrawable preview = (BitmapDrawable)snapshot.getDrawable();
                        bigImageView.setImage(ImageSource.uri((Uri)Uri.fromFile((File)resource)).dimensions(size[0], size[1]), ImageSource.cachedBitmap((Bitmap)preview.getBitmap()));
                    } else {
                        bigImageView.setImage(ImageSource.uri((Uri)Uri.fromFile((File)resource)));
                    }
                } else {
                    progressBar.setVisibility(8);
                    bigImageView.setVisibility(8);
                    imageView.setVisibility(0);
                    imageView.setZoomable(true);
                    Glide.with((View)imageView).load(resource).apply(((RequestOptions)new RequestOptions().error(SmartGlideImageLoader.this.errImg)).override(size[0], size[1])).into((ImageView)imageView);
                }
            }
        });
    }

    @Override
    public void loadSnapshot(@NonNull Object uri, final @NonNull PhotoView snapshot) {
        Glide.with((View)snapshot).downloadOnly().load(uri).into((Target)new ImageDownloadTarget(){

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
            }

            @Override
            public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
                int maxW = XPopupUtils.getWindowWidth(snapshot.getContext());
                int maxH = XPopupUtils.getScreenHeight(snapshot.getContext());
                int[] size = XPopupUtils.getImageSize(resource);
                if (size[0] > maxW || size[1] > maxH) {
                    snapshot.setImageBitmap(XPopupUtils.getBitmap(resource, maxW, maxH));
                } else {
                    Glide.with((View)snapshot).load(resource).apply(new RequestOptions().override(size[0], size[1])).into((ImageView)snapshot);
                }
            }
        });
    }

    @Override
    public File getImageFile(@NonNull Context context, @NonNull Object uri) {
        try {
            return (File)Glide.with((Context)context).downloadOnly().load(uri).submit().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

