/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.transition.ChangeBounds;
import androidx.transition.Fade;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.util.XPopupUtils;

public class LoadingPopupView
extends CenterPopupView {
    private TextView tv_title;
    private CharSequence title;

    public LoadingPopupView(@NonNull Context context, int bindLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId != 0 ? this.bindLayoutId : R.layout._xpopup_center_impl_loading;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getPopupImplView().setElevation(10.0f);
        }
        if (this.bindLayoutId == 0) {
            this.getPopupImplView().setBackground(XPopupUtils.createDrawable(Color.parseColor((String)"#CF000000"), this.popupInfo.borderRadius));
        }
        this.setup();
    }

    protected void setup() {
        if (this.tv_title == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)LoadingPopupView.this.centerPopupContainer, (Transition)new TransitionSet().setDuration((long)XPopup.getAnimationDuration()).addTransition((Transition)new Fade()).addTransition((Transition)new ChangeBounds()));
                if (LoadingPopupView.this.title == null || LoadingPopupView.this.title.length() == 0) {
                    LoadingPopupView.this.tv_title.setVisibility(8);
                } else {
                    LoadingPopupView.this.tv_title.setVisibility(0);
                    LoadingPopupView.this.tv_title.setText(LoadingPopupView.this.title);
                }
            }
        });
    }

    public LoadingPopupView setTitle(CharSequence title) {
        this.title = title;
        this.setup();
        return this;
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        if (this.tv_title == null) {
            return;
        }
        this.tv_title.setText((CharSequence)"");
        this.tv_title.setVisibility(8);
    }
}

