/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class PartShadowPopupView
extends BasePopupView {
    protected PartShadowContainer attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
    public boolean isShowUp;

    public PartShadowPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_partshadow_popup_view;
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected void initPopupContent() {
        if (this.attachPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.getAtView() == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or touchPoint must not be null for AttachPopupView \uff01");
        }
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.targetView = this.getPopupContentView();
        }
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.doAttach();
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.doAttach();
            }
        });
    }

    public void doAttach() {
        int tx;
        if (this.popupInfo.getAtView() == null) {
            throw new IllegalArgumentException("atView must not be null for PartShadowPopupView\uff01");
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getPopupContentView().getLayoutParams();
        params.width = this.getMeasuredWidth();
        int[] locations = new int[2];
        this.popupInfo.getAtView().getLocationOnScreen(locations);
        Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
        if (this.popupInfo.isCenterHorizontal && this.getPopupImplView() != null) {
            tx = (rect.left + rect.right) / 2 - this.getPopupImplView().getMeasuredWidth() / 2;
            this.getPopupImplView().setTranslationX((float)tx);
        } else {
            tx = rect.left + this.popupInfo.offsetX;
            if (tx + this.getPopupImplView().getMeasuredWidth() > XPopupUtils.getWindowWidth(this.getContext())) {
                tx -= tx + this.getPopupImplView().getMeasuredWidth() - XPopupUtils.getWindowWidth(this.getContext());
            }
            this.getPopupImplView().setTranslationX((float)tx);
        }
        int centerY = rect.top + rect.height() / 2;
        if ((centerY > this.getMeasuredHeight() / 2 || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom) {
            params.height = rect.top;
            this.isShowUp = true;
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 80;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        } else {
            params.height = this.getMeasuredHeight() - rect.bottom;
            this.isShowUp = false;
            params.topMargin = rect.bottom;
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 48;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        }
        this.getPopupContentView().setLayoutParams((ViewGroup.LayoutParams)params);
        this.getPopupImplView().setTranslationY((float)this.popupInfo.offsetY);
        this.attachPopupContainer.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
                return false;
            }
        });
        this.attachPopupContainer.setOnClickOutsideListener(new OnClickOutsideListener(){

            @Override
            public void onClickOutside() {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
            }
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
            this.dismiss();
        }
        if (this.dialog != null && this.popupInfo.isClickThrough) {
            this.dialog.passClick(event);
        }
        return this.popupInfo.isClickThrough;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupImplView(), this.isShowUp ? PopupAnimation.TranslateFromBottom : PopupAnimation.TranslateFromTop);
    }
}

