/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util.navbar;

import android.text.TextUtils;
import java.lang.reflect.Method;

public class OSUtils {
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_EMUI_VERSION_NAME = "ro.build.version.emui";
    private static final String KEY_DISPLAY = "ro.build.display.id";

    public static boolean isMIUI() {
        String property = OSUtils.getSystemProperty(KEY_MIUI_VERSION_NAME, "");
        return !TextUtils.isEmpty((CharSequence)property);
    }

    public static boolean isEMUI() {
        String property = OSUtils.getSystemProperty(KEY_EMUI_VERSION_NAME, "");
        return !TextUtils.isEmpty((CharSequence)property);
    }

    public static String getEMUIVersion() {
        return OSUtils.isEMUI() ? OSUtils.getSystemProperty(KEY_EMUI_VERSION_NAME, "") : "";
    }

    public static boolean isEMUI3_1() {
        String property = OSUtils.getEMUIVersion();
        return "EmotionUI 3".equals(property) || property.contains("EmotionUI_3.1");
    }

    public static boolean isEMUI3_0() {
        String property = OSUtils.getEMUIVersion();
        return property.contains("EmotionUI_3.0");
    }

    public static boolean isEMUI3_x() {
        return OSUtils.isEMUI3_0() || OSUtils.isEMUI3_1();
    }

    private static String getSystemProperty(String key, String defaultValue) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method method = clz.getMethod("get", String.class, String.class);
            return (String)method.invoke(clz, key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

