/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util.navbar;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.lxj.xpopup.util.navbar.OSUtils;
import com.lxj.xpopup.util.navbar.OnNavigationBarListener;
import java.util.ArrayList;

public final class NavigationBarObserver
extends ContentObserver {
    static final String IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW = "force_fsg_nav_bar";
    static final String IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW = "navigationbar_is_min";
    private ArrayList<OnNavigationBarListener> mListeners;
    private Context context;
    private Boolean mIsRegister = false;

    public static NavigationBarObserver getInstance() {
        return NavigationBarObserverInstance.INSTANCE;
    }

    private NavigationBarObserver() {
        super(new Handler(Looper.getMainLooper()));
    }

    public void register(Context context) {
        this.context = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 17 && context != null && context.getContentResolver() != null && !this.mIsRegister.booleanValue()) {
            Uri uri = null;
            if (OSUtils.isMIUI()) {
                uri = Settings.Global.getUriFor((String)IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW);
            } else if (OSUtils.isEMUI()) {
                uri = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getUriFor((String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW) : Settings.Global.getUriFor((String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW);
            }
            if (uri != null) {
                context.getContentResolver().registerContentObserver(uri, true, (ContentObserver)this);
                this.mIsRegister = true;
            }
        }
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (Build.VERSION.SDK_INT >= 17 && this.context != null && this.context.getContentResolver() != null && this.mListeners != null && !this.mListeners.isEmpty()) {
            int show = 0;
            if (OSUtils.isMIUI()) {
                show = Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)IMMERSION_MIUI_NAVIGATION_BAR_HIDE_SHOW, (int)0);
            } else if (OSUtils.isEMUI()) {
                show = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW, (int)0) : Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)IMMERSION_EMUI_NAVIGATION_BAR_HIDE_SHOW, (int)0);
            }
            for (OnNavigationBarListener onNavigationBarListener : this.mListeners) {
                onNavigationBarListener.onNavigationBarChange(show != 1);
            }
        }
    }

    public void addOnNavigationBarListener(OnNavigationBarListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeOnNavigationBarListener(OnNavigationBarListener listener) {
        if (this.mIsRegister.booleanValue()) {
            this.context.getContentResolver().unregisterContentObserver((ContentObserver)this);
            this.mIsRegister = false;
        }
        this.context = null;
        if (listener == null || this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    private static class NavigationBarObserverInstance {
        private static final NavigationBarObserver INSTANCE = new NavigationBarObserver();

        private NavigationBarObserverInstance() {
        }
    }
}

