/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.BasePopupView;

public class FullScreenDialog
extends Dialog {
    BasePopupView contentView;

    public FullScreenDialog(@NonNull Context context) {
        super(context, R.style._XPopup_TransparentDialog);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getWindow() == null) {
            return;
        }
        if (this.contentView != null && this.contentView.popupInfo.enableShowWhenAppBackground) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.getWindow().setType(2038);
            } else {
                this.getWindow().setType(2003);
            }
        }
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.getWindow().setLayout(-1, -1);
        this.getWindow().setSoftInputMode(16);
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            this.setWindowFlag(0x4000000, true);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.setWindowFlag(0x4000000, false);
            this.getWindow().setStatusBarColor(0);
        }
        this.autoSetStatusBarMode();
        this.setContentView((View)this.contentView);
    }

    public boolean isActivityStatusBarLightMode() {
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = ((Activity)this.contentView.getContext()).getWindow().getDecorView();
            int vis = decorView.getSystemUiVisibility();
            return (vis & 0x2000) != 0;
        }
        return false;
    }

    public void setWindowFlag(int bits, boolean on) {
        WindowManager.LayoutParams winParams = this.getWindow().getAttributes();
        winParams.flags = on ? (winParams.flags |= bits) : (winParams.flags &= ~bits);
        this.getWindow().setAttributes(winParams);
    }

    public void autoSetStatusBarMode() {
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = this.getWindow().getDecorView();
            int vis = decorView.getSystemUiVisibility();
            boolean isLightMode = this.isActivityStatusBarLightMode();
            vis = isLightMode ? (vis |= 0x2000) : (vis &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(vis);
        }
    }

    public FullScreenDialog setContent(BasePopupView view) {
        this.contentView = view;
        return this;
    }
}

