/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.EmptyAnimator;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.animator.TranslateAlphaAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.ImageViewerPopupView;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.RomUtils;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.util.navbar.NavigationBarObserver;
import com.lxj.xpopup.util.navbar.OnNavigationBarListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class BasePopupView
extends FrameLayout
implements OnNavigationBarListener {
    private static Stack<BasePopupView> stack = new Stack();
    public PopupInfo popupInfo;
    protected PopupAnimator popupContentAnimator;
    protected ShadowBgAnimator shadowBgAnimator;
    private int touchSlop;
    public PopupStatus popupStatus = PopupStatus.Dismiss;
    private boolean isCreated = false;
    private boolean hasMoveUp = false;
    private Runnable doAfterShowTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.popupStatus = PopupStatus.Show;
            BasePopupView.this.onShow();
            if (BasePopupView.this instanceof FullScreenPopupView) {
                BasePopupView.this.focusAndProcessBackPress();
            }
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onShow();
            }
            if (XPopupUtils.getDecorViewInvisibleHeight((Activity)BasePopupView.this.getContext()) > 0 && !BasePopupView.this.hasMoveUp) {
                XPopupUtils.moveUpToKeyboard(XPopupUtils.getDecorViewInvisibleHeight((Activity)BasePopupView.this.getContext()), BasePopupView.this);
            }
        }
    };
    private ShowSoftInputTask showSoftInputTask;
    private Runnable doAfterDismissTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.onDismiss();
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onDismiss();
            }
            if (BasePopupView.this.dismissWithRunnable != null) {
                BasePopupView.this.dismissWithRunnable.run();
                BasePopupView.this.dismissWithRunnable = null;
            }
            BasePopupView.this.popupStatus = PopupStatus.Dismiss;
            NavigationBarObserver.getInstance().removeOnNavigationBarListener(BasePopupView.this);
            if (!stack.isEmpty()) {
                stack.pop();
            }
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.isRequestFocus) {
                if (!stack.isEmpty()) {
                    ((BasePopupView)stack.get(stack.size() - 1)).focusAndProcessBackPress();
                } else {
                    View needFocusView = ((Activity)BasePopupView.this.getContext()).findViewById(0x1020002);
                    if (needFocusView != null) {
                        needFocusView.setFocusable(true);
                        needFocusView.setFocusableInTouchMode(true);
                    }
                }
            }
            if (BasePopupView.this.popupInfo.decorView != null) {
                BasePopupView.this.popupInfo.decorView.removeView((View)BasePopupView.this);
                KeyboardUtils.removeLayoutChangeListener((View)BasePopupView.this.popupInfo.decorView, BasePopupView.this);
            }
        }
    };
    Runnable dismissWithRunnable;
    private float x;
    private float y;

    public BasePopupView(@NonNull Context context) {
        super(context);
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.shadowBgAnimator = new ShadowBgAnimator((View)this);
        View contentView = LayoutInflater.from((Context)context).inflate(this.getPopupLayoutId(), (ViewGroup)this, false);
        contentView.setAlpha(0.0f);
        this.addView(contentView);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void init() {
        if (this.popupStatus == PopupStatus.Showing) {
            return;
        }
        this.popupStatus = PopupStatus.Showing;
        NavigationBarObserver.getInstance().register(this.getContext());
        NavigationBarObserver.getInstance().addOnNavigationBarListener(this);
        if (!this.isCreated) {
            this.initPopupContent();
        }
        if (!(this instanceof FullScreenPopupView) && !(this instanceof ImageViewerPopupView)) {
            XPopupUtils.setWidthHeight(this.getTargetSizeView(), this.getMaxWidth() != 0 && this.getPopupWidth() > this.getMaxWidth() ? this.getMaxWidth() : this.getPopupWidth(), this.getMaxHeight() != 0 && this.getPopupHeight() > this.getMaxHeight() ? this.getMaxHeight() : this.getPopupHeight());
        }
        if (!this.isCreated) {
            this.isCreated = true;
            this.onCreate();
            if (this.popupInfo.xPopupCallback != null) {
                this.popupInfo.xPopupCallback.onCreated();
            }
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.applySize(false);
                BasePopupView.this.getPopupContentView().setAlpha(1.0f);
                BasePopupView.this.collectAnimator();
                if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                    BasePopupView.this.popupInfo.xPopupCallback.beforeShow();
                }
                BasePopupView.this.doShowAnimation();
                BasePopupView.this.doAfterShow();
                if (!(BasePopupView.this instanceof FullScreenPopupView)) {
                    BasePopupView.this.focusAndProcessBackPress();
                }
            }
        }, 50L);
    }

    private void collectAnimator() {
        if (this.popupContentAnimator == null) {
            if (this.popupInfo.customAnimator != null) {
                this.popupContentAnimator = this.popupInfo.customAnimator;
                this.popupContentAnimator.targetView = this.getPopupContentView();
            } else {
                this.popupContentAnimator = this.genAnimatorByPopupType();
                if (this.popupContentAnimator == null) {
                    this.popupContentAnimator = this.getPopupAnimator();
                }
            }
            this.shadowBgAnimator.initAnimator();
            if (this.popupContentAnimator != null) {
                this.popupContentAnimator.initAnimator();
            }
        }
    }

    @Override
    public void onNavigationBarChange(boolean show) {
        if (!show) {
            this.applyFull();
        } else {
            this.applySize(true);
        }
    }

    protected void applyFull() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.topMargin = 0;
        params.leftMargin = 0;
        params.bottomMargin = 0;
        params.rightMargin = 0;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void applySize(boolean isShowNavBar) {
        boolean isNavBarShown;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        int rotation = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
        boolean bl = isNavBarShown = isShowNavBar || XPopupUtils.isNavBarVisible(this.getContext());
        if (rotation == 0) {
            params.leftMargin = 0;
            params.rightMargin = 0;
            params.bottomMargin = isNavBarShown ? XPopupUtils.getNavBarHeight() : 0;
        } else if (rotation == 1) {
            params.bottomMargin = 0;
            params.rightMargin = isNavBarShown ? XPopupUtils.getNavBarHeight() : 0;
            params.leftMargin = 0;
        } else if (rotation == 3) {
            params.bottomMargin = 0;
            params.leftMargin = 0;
            params.rightMargin = isNavBarShown ? XPopupUtils.getNavBarHeight() : 0;
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public BasePopupView show() {
        if (this.getParent() != null) {
            return this;
        }
        Activity activity = (Activity)this.getContext();
        this.popupInfo.decorView = (ViewGroup)activity.getWindow().getDecorView();
        KeyboardUtils.registerSoftInputChangedListener(activity, this, new KeyboardUtils.OnSoftInputChangedListener(){

            @Override
            public void onSoftInputChanged(int height) {
                if (height == 0) {
                    XPopupUtils.moveDown(BasePopupView.this);
                    BasePopupView.this.hasMoveUp = false;
                } else {
                    XPopupUtils.moveUpToKeyboard(height, BasePopupView.this);
                    BasePopupView.this.hasMoveUp = true;
                }
            }
        });
        this.popupInfo.decorView.post(new Runnable(){

            @Override
            public void run() {
                if (BasePopupView.this.getParent() != null) {
                    ((ViewGroup)BasePopupView.this.getParent()).removeView((View)BasePopupView.this);
                }
                if (RomUtils.isSamsung()) {
                    BasePopupView.this.popupInfo.decorView.addView((View)BasePopupView.this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, XPopupUtils.getAppScreenHeight(BasePopupView.this.getContext())));
                } else if (RomUtils.isMIUI12()) {
                    if (XPopupUtils.isNavBarVisible(BasePopupView.this.getContext())) {
                        BasePopupView.this.popupInfo.decorView.addView((View)BasePopupView.this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, XPopupUtils.getAppScreenHeight(BasePopupView.this.getContext())));
                    } else {
                        BasePopupView.this.popupInfo.decorView.addView((View)BasePopupView.this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    }
                } else {
                    BasePopupView.this.popupInfo.decorView.addView((View)BasePopupView.this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                }
                BasePopupView.this.init();
            }
        });
        return this;
    }

    protected void doAfterShow() {
        this.removeCallbacks(this.doAfterShowTask);
        this.postDelayed(this.doAfterShowTask, this.getAnimationDuration());
    }

    public void focusAndProcessBackPress() {
        if (this.popupInfo.isRequestFocus) {
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            if (!stack.contains(this)) {
                stack.push(this);
            }
        }
        this.setOnKeyListener(new BackPressListener());
        if (!this.popupInfo.autoFocusEditText) {
            this.showSoftInput((View)this);
        }
        ArrayList<EditText> list = new ArrayList<EditText>();
        XPopupUtils.findAllEditText(list, (ViewGroup)this.getPopupContentView());
        for (int i = 0; i < list.size(); ++i) {
            EditText et = list.get(i);
            et.setOnKeyListener((View.OnKeyListener)new BackPressListener());
            if (i != 0 || !this.popupInfo.autoFocusEditText) continue;
            et.setFocusable(true);
            et.setFocusableInTouchMode(true);
            et.requestFocus();
            this.showSoftInput((View)et);
        }
    }

    protected void showSoftInput(View focusView) {
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            if (this.showSoftInputTask == null) {
                this.showSoftInputTask = new ShowSoftInputTask(focusView);
            } else {
                this.removeCallbacks(this.showSoftInputTask);
            }
            this.postDelayed(this.showSoftInputTask, 10L);
        }
    }

    protected void dismissOrHideSoftInput() {
        if (KeyboardUtils.sDecorViewInvisibleHeightPre == 0) {
            this.dismiss();
        } else {
            KeyboardUtils.hideSoftInput((View)this);
        }
    }

    protected PopupAnimator genAnimatorByPopupType() {
        if (this.popupInfo == null || this.popupInfo.popupAnimation == null) {
            return null;
        }
        switch (this.popupInfo.popupAnimation) {
            case ScaleAlphaFromCenter: 
            case ScaleAlphaFromLeftTop: 
            case ScaleAlphaFromRightTop: 
            case ScaleAlphaFromLeftBottom: 
            case ScaleAlphaFromRightBottom: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateAlphaFromLeft: 
            case TranslateAlphaFromTop: 
            case TranslateAlphaFromRight: 
            case TranslateAlphaFromBottom: {
                return new TranslateAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateFromLeft: 
            case TranslateFromTop: 
            case TranslateFromRight: 
            case TranslateFromBottom: {
                return new TranslateAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case ScrollAlphaFromLeft: 
            case ScrollAlphaFromLeftTop: 
            case ScrollAlphaFromTop: 
            case ScrollAlphaFromRightTop: 
            case ScrollAlphaFromRight: 
            case ScrollAlphaFromRightBottom: 
            case ScrollAlphaFromBottom: 
            case ScrollAlphaFromLeftBottom: {
                return new ScrollScaleAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case NoAnimation: {
                return new EmptyAnimator();
            }
        }
        return null;
    }

    protected abstract int getPopupLayoutId();

    protected int getImplLayoutId() {
        return -1;
    }

    protected PopupAnimator getPopupAnimator() {
        return null;
    }

    protected void initPopupContent() {
    }

    protected void onCreate() {
    }

    protected void applyDarkTheme() {
    }

    protected void doShowAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.isZeroDuration = this.popupInfo.popupAnimation == PopupAnimation.NoAnimation;
            this.shadowBgAnimator.animateShow();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateShow();
        }
    }

    protected void doDismissAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.animateDismiss();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateDismiss();
        }
    }

    public View getPopupContentView() {
        return this.getChildAt(0);
    }

    public View getPopupImplView() {
        return ((ViewGroup)this.getPopupContentView()).getChildAt(0);
    }

    public int getAnimationDuration() {
        return this.popupInfo.popupAnimation == PopupAnimation.NoAnimation ? 10 : XPopup.getAnimationDuration();
    }

    protected int getMaxWidth() {
        return 0;
    }

    protected int getMaxHeight() {
        return this.popupInfo.maxHeight;
    }

    protected int getPopupWidth() {
        return 0;
    }

    protected int getPopupHeight() {
        return 0;
    }

    protected View getTargetSizeView() {
        return this.getPopupContentView();
    }

    public void dismiss() {
        if (this.popupStatus == PopupStatus.Dismissing || this.popupStatus == PopupStatus.Dismiss) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.clearFocus();
        this.doDismissAnimation();
        this.doAfterDismiss();
    }

    public void delayDismiss(long delay) {
        if (delay < 0L) {
            delay = 0L;
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.dismiss();
            }
        }, delay);
    }

    public void delayDismissWith(long delay, Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.delayDismiss(delay);
    }

    protected void doAfterDismiss() {
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.removeCallbacks(this.doAfterDismissTask);
        this.postDelayed(this.doAfterDismissTask, this.getAnimationDuration());
    }

    public void dismissWith(Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.dismiss();
    }

    public boolean isShow() {
        return this.popupStatus != PopupStatus.Dismiss;
    }

    public boolean isDismiss() {
        return this.popupStatus == PopupStatus.Dismiss;
    }

    public void toggle() {
        if (this.isShow()) {
            this.dismiss();
        } else {
            this.show();
        }
    }

    protected void onDismiss() {
        FragmentManager manager;
        List fragments;
        if (this.getContext() instanceof FragmentActivity && (fragments = (manager = ((FragmentActivity)this.getContext()).getSupportFragmentManager()).getFragments()) != null && fragments.size() > 0 && this.getInternalFragmentNames() != null) {
            for (int i = 0; i < fragments.size(); ++i) {
                String name = ((Fragment)fragments.get(i)).getClass().getSimpleName();
                if (!this.getInternalFragmentNames().contains(name)) continue;
                manager.beginTransaction().remove((Fragment)fragments.get(i)).commitAllowingStateLoss();
            }
        }
    }

    protected List<String> getInternalFragmentNames() {
        return null;
    }

    protected void onShow() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        stack.clear();
        this.removeCallbacks(this.doAfterShowTask);
        this.removeCallbacks(this.doAfterDismissTask);
        KeyboardUtils.removeLayoutChangeListener((View)this.popupInfo.decorView, this);
        if (this.showSoftInputTask != null) {
            this.removeCallbacks(this.showSoftInputTask);
        }
        this.popupStatus = PopupStatus.Dismiss;
        this.showSoftInputTask = null;
        this.hasMoveUp = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        Rect rect = new Rect();
        this.getPopupContentView().getGlobalVisibleRect(rect);
        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    break;
                }
                case 1: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)this.touchSlop && this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                        this.dismiss();
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                }
            }
        }
        return true;
    }

    class BackPressListener
    implements View.OnKeyListener {
        BackPressListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 1) {
                if (BasePopupView.this.popupInfo.isDismissOnBackPressed.booleanValue() && (BasePopupView.this.popupInfo.xPopupCallback == null || !BasePopupView.this.popupInfo.xPopupCallback.onBackPressed())) {
                    BasePopupView.this.dismissOrHideSoftInput();
                }
                return true;
            }
            return false;
        }
    }

    class ShowSoftInputTask
    implements Runnable {
        View focusView;
        boolean isDone = false;

        public ShowSoftInputTask(View focusView) {
            this.focusView = focusView;
        }

        @Override
        public void run() {
            if (this.focusView != null && !this.isDone) {
                this.isDone = true;
                KeyboardUtils.showSoftInput(this.focusView);
            }
        }
    }
}

