/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;

public class PartShadowContainer
extends CardView {
    public boolean isDismissOnTouchOutside = true;
    private float x;
    private float y;
    private long downTime;
    private OnClickOutsideListener listener;

    public PartShadowContainer(@NonNull Context context) {
        super(context);
    }

    public PartShadowContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PartShadowContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent event) {
        View implView = this.getChildAt(0);
        Rect outsideRect = null;
        FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
        outsideRect = implParams.gravity == 48 ? new Rect(0, implView.getHeight(), this.getWidth(), this.getHeight()) : new Rect(0, 0, this.getWidth(), this.getHeight() - implView.getHeight());
        if (XPopupUtils.isInRect(event.getX(), event.getY(), outsideRect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    this.downTime = System.currentTimeMillis();
                    break;
                }
                case 1: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop() && System.currentTimeMillis() - this.downTime < 350L && this.isDismissOnTouchOutside && this.listener != null) {
                        this.listener.onClickOutside();
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                    this.downTime = 0L;
                }
            }
        }
        return true;
    }

    public void setOnClickOutsideListener(OnClickOutsideListener listener) {
        this.listener = listener;
    }
}

