/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;

public abstract class PartShadowPopupView
extends AttachPopupView {
    public PartShadowPopupView(@NonNull Context context) {
        super(context);
        this.defaultOffsetY = 0;
    }

    @Override
    protected void doAttach() {
        if (this.popupInfo.getAtView() == null) {
            throw new IllegalArgumentException("atView must not be null for PartShadowPopupView\uff01");
        }
        this.shadowBgAnimator.targetView = this.getPopupContentView();
        ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
        params.width = this.getMeasuredWidth();
        int[] locations = new int[2];
        this.popupInfo.getAtView().getLocationOnScreen(locations);
        Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
        int centerY = rect.top + rect.height() / 2;
        if (centerY > this.getMeasuredHeight() / 2) {
            params.height = rect.top;
            this.isShowUp = true;
            this.getPopupContentView().setTranslationY((float)(-this.defaultOffsetY));
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 80;
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        } else {
            params.height = this.getMeasuredHeight() - rect.bottom;
            if (XPopupUtils.hasNavigationBar(this.getContext()) && !XPopupUtils.isFuckDevice()) {
                params.height -= XPopupUtils.getNavBarHeight();
            }
            this.isShowUp = false;
            this.getPopupContentView().setTranslationY((float)(rect.bottom + this.defaultOffsetY));
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 48;
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        }
        this.getPopupContentView().setLayoutParams(params);
        this.attachPopupContainer.setCardBackgroundColor(0);
        this.attachPopupContainer.setCardElevation(0.0f);
        this.attachPopupContainer.setOnClickOutsideListener(new OnClickOutsideListener(){

            @Override
            public void onClickOutside() {
                PartShadowPopupView.this.dismiss();
            }
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        this.dismiss();
        return false;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupImplView(), this.isShowUp ? PopupAnimation.TranslateFromBottom : PopupAnimation.TranslateFromTop);
    }
}

