/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class AttachPopupView
extends BasePopupView {
    protected int defaultOffsetY = 6;
    protected int defaultOffsetX = 0;
    protected PartShadowContainer attachPopupContainer;
    protected boolean isShowUp;
    boolean isShowLeft;

    public AttachPopupView(@NonNull Context context) {
        super(context);
        this.defaultOffsetY = XPopupUtils.dp2px(context, this.defaultOffsetY);
        this.defaultOffsetX = XPopupUtils.dp2px(context, this.defaultOffsetX);
        this.attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    public AttachPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AttachPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.popupInfo.getAtView() == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or touchPoint must not be null for AttachView type\uff01");
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                AttachPopupView.this.doAttach();
            }
        });
    }

    protected void doAttach() {
        float maxY = XPopupUtils.getWindowHeight(this.getContext());
        float maxX = 0.0f;
        float translationX = 0.0f;
        float translationY = 0.0f;
        if (this.popupInfo.touchPoint != null) {
            maxX = Math.max(this.popupInfo.touchPoint.x - (float)this.getPopupContentView().getMeasuredWidth(), 0.0f);
            this.isShowUp = this.popupInfo.touchPoint.y + (float)this.getPopupContentView().getMeasuredHeight() > maxY;
            boolean bl = this.isShowLeft = this.popupInfo.touchPoint.x < (float)(XPopupUtils.getWindowWidth(this.getContext()) / 2);
            if (this.isShowUp) {
                translationX = (this.isShowLeft ? this.popupInfo.touchPoint.x : maxX) + (float)this.defaultOffsetX;
                translationY = this.popupInfo.touchPoint.y - (float)this.getPopupContentView().getMeasuredHeight() - (float)this.defaultOffsetY;
            } else {
                translationX = (this.isShowLeft ? this.popupInfo.touchPoint.x : maxX) + (float)this.defaultOffsetX;
                translationY = this.popupInfo.touchPoint.y + (float)this.defaultOffsetY;
            }
        } else {
            int[] locations = new int[2];
            this.popupInfo.getAtView().getLocationOnScreen(locations);
            Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
            maxX = Math.max(rect.right - this.getPopupContentView().getMeasuredWidth(), 0);
            int centerX = (rect.left + rect.right) / 2;
            this.isShowUp = (float)(rect.bottom + this.getPopupContentView().getMeasuredHeight()) > maxY;
            boolean bl = this.isShowLeft = centerX < XPopupUtils.getWindowWidth(this.getContext()) / 2;
            if (this.isShowUp) {
                translationX = (this.isShowLeft ? (float)rect.left : maxX) + (float)this.defaultOffsetX;
                translationY = rect.top - this.getPopupContentView().getMeasuredHeight() - this.defaultOffsetY;
            } else {
                translationX = (this.isShowLeft ? (float)rect.left : maxX) + (float)this.defaultOffsetX;
                translationY = rect.bottom + this.defaultOffsetY;
            }
        }
        this.getPopupContentView().setTranslationX(translationX);
        this.getPopupContentView().setTranslationY(translationY);
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowUp ? (this.isShowLeft ? new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromLeftBottom) : new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromRightBottom)) : (this.isShowLeft ? new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromLeftTop) : new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromRightTop));
        return animator;
    }
}

