/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.animator.TranslateAlphaAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.interfaces.PopupInterface;
import com.lxj.xpopup.util.XPopupUtils;

public abstract class BasePopupView
extends FrameLayout
implements PopupInterface {
    public PopupInfo popupInfo;
    protected PopupAnimator popupContentAnimator;
    protected PopupAnimator shadowBgAnimator;
    private int touchSlop;
    public PopupStatus popupStatus = PopupStatus.Dismiss;
    Runnable afterAnimationEnd;
    private float x;
    private float y;
    private long downTime;

    public BasePopupView(@NonNull Context context) {
        super(context);
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.shadowBgAnimator = new ShadowBgAnimator((View)this);
        View contentView = LayoutInflater.from((Context)context).inflate(this.getPopupLayoutId(), (ViewGroup)this, false);
        contentView.setAlpha(0.0f);
        this.addView(contentView);
        if (XPopupUtils.hasNavigationBar(this.getContext()) && !XPopupUtils.isFuckDevice()) {
            this.setPadding(0, 0, 0, XPopupUtils.getNavBarHeight());
        }
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    if (BasePopupView.this.popupInfo.isDismissOnBackPressed.booleanValue()) {
                        BasePopupView.this.dismiss();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init(final Runnable afterAnimationStarted, Runnable afterAnimationEnd) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return;
        }
        this.afterAnimationEnd = afterAnimationEnd;
        this.initPopupContent();
        this.post(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.getPopupContentView().setAlpha(1.0f);
                if (BasePopupView.this.popupInfo.customAnimator != null) {
                    BasePopupView.this.popupContentAnimator = BasePopupView.this.popupInfo.customAnimator;
                    BasePopupView.this.popupContentAnimator.targetView = BasePopupView.this.getPopupContentView();
                } else {
                    BasePopupView.this.popupContentAnimator = BasePopupView.this.genAnimatorByPopupType();
                    if (BasePopupView.this.popupContentAnimator == null) {
                        BasePopupView.this.popupContentAnimator = BasePopupView.this.getPopupAnimator();
                    }
                }
                BasePopupView.this.shadowBgAnimator.initAnimator();
                if (BasePopupView.this.popupContentAnimator != null) {
                    BasePopupView.this.popupContentAnimator.initAnimator();
                    BasePopupView.this.shadowBgAnimator.animateDuration = BasePopupView.this.popupContentAnimator.animateDuration;
                }
                BasePopupView.this.popupStatus = PopupStatus.Showing;
                BasePopupView.this.doShowAnimation();
                BasePopupView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        afterAnimationStarted.run();
                        BasePopupView.this.popupStatus = PopupStatus.Show;
                    }
                }, 20L);
            }
        });
    }

    protected PopupAnimator genAnimatorByPopupType() {
        if (this.popupInfo == null || this.popupInfo.popupAnimation == null) {
            return null;
        }
        switch (this.popupInfo.popupAnimation) {
            case ScaleAlphaFromCenter: 
            case ScaleAlphaFromLeftTop: 
            case ScaleAlphaFromRightTop: 
            case ScaleAlphaFromLeftBottom: 
            case ScaleAlphaFromRightBottom: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateAlphaFromLeft: 
            case TranslateAlphaFromTop: 
            case TranslateAlphaFromRight: 
            case TranslateAlphaFromBottom: {
                return new TranslateAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateFromLeft: 
            case TranslateFromTop: 
            case TranslateFromRight: 
            case TranslateFromBottom: {
                return new TranslateAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case ScrollAlphaFromLeft: 
            case ScrollAlphaFromLeftTop: 
            case ScrollAlphaFromTop: 
            case ScrollAlphaFromRightTop: 
            case ScrollAlphaFromRight: 
            case ScrollAlphaFromRightBottom: 
            case ScrollAlphaFromBottom: 
            case ScrollAlphaFromLeftBottom: {
                return new ScrollScaleAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
        }
        return null;
    }

    protected abstract int getPopupLayoutId();

    protected abstract int getImplLayoutId();

    protected PopupAnimator getPopupAnimator() {
        if (this.popupInfo == null || this.popupInfo.popupType == null) {
            return null;
        }
        switch (this.popupInfo.popupType) {
            case Center: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), PopupAnimation.ScaleAlphaFromCenter);
            }
            case Bottom: {
                return new TranslateAnimator(this.getPopupContentView(), PopupAnimation.TranslateFromBottom);
            }
            case AttachView: {
                return new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromLeftTop);
            }
        }
        return null;
    }

    protected void initPopupContent() {
    }

    @Override
    public void doShowAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.animateShow();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateShow();
        }
    }

    @Override
    public void doDismissAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.animateDismiss();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateDismiss();
        }
    }

    @Override
    public View getPopupContentView() {
        return this.getChildAt(0);
    }

    public View getPopupImplView() {
        return ((ViewGroup)this.getPopupContentView()).getChildAt(0);
    }

    @Override
    public int getAnimationDuration() {
        return this.popupContentAnimator == null ? 400 : this.popupContentAnimator.animateDuration;
    }

    protected int getMaxWidth() {
        return 0;
    }

    protected int getMaxHeight() {
        return this.popupInfo.maxHeight;
    }

    public void dismiss() {
        if (this.popupStatus != PopupStatus.Show) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.doDismissAnimation();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.afterAnimationEnd.run();
                BasePopupView.this.popupStatus = PopupStatus.Dismiss;
                BasePopupView.this.popupInfo = null;
            }
        }, this.getAnimationDuration());
    }

    public boolean onTouchEvent(MotionEvent event) {
        Rect rect = new Rect();
        this.getPopupContentView().getGlobalVisibleRect(rect);
        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    this.downTime = System.currentTimeMillis();
                    break;
                }
                case 1: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)this.touchSlop && System.currentTimeMillis() - this.downTime < 350L && this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                        this.dismiss();
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                    this.downTime = 0L;
                }
            }
        }
        return true;
    }
}

