/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PointF;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.core.BottomPopupView;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupType;
import com.lxj.xpopup.impl.AttachListPopupView;
import com.lxj.xpopup.impl.BottomListPopupView;
import com.lxj.xpopup.impl.CenterListPopupView;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.impl.InputConfirmPopupView;
import com.lxj.xpopup.impl.LoadingPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnConfirmListener;
import com.lxj.xpopup.interfaces.OnInputConfirmListener;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.interfaces.XPopupCallback;
import com.lxj.xpopup.util.KeyboardUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class XPopup {
    private static XPopup instance = null;
    private static WeakReference<Context> contextRef;
    private PopupInfo tempInfo = null;
    private BasePopupView tempView;
    private Handler handler = new Handler();
    private ViewGroup decorView = null;
    private int primaryColor = Color.parseColor((String)"#121212");
    private static ArrayList<BasePopupView> popupViews;

    private XPopup() {
    }

    public static XPopup get(Context ctx) {
        if (instance == null) {
            instance = new XPopup();
        }
        if ((contextRef = new WeakReference<Context>(ctx)).get() == null) {
            throw new IllegalArgumentException("context can not be null!");
        }
        if (!(contextRef.get() instanceof Activity)) {
            throw new IllegalArgumentException("context must be an instance of Activity");
        }
        KeyboardUtils.registerSoftInputChangedListener((Activity)contextRef.get(), new KeyboardUtils.OnSoftInputChangedListener(){

            @Override
            public void onSoftInputChanged(int height) {
                if (height == 0) {
                    for (BasePopupView pv : popupViews) {
                        pv.getPopupContentView().animate().translationY(0.0f).setDuration(300L).start();
                    }
                }
            }
        });
        return instance;
    }

    public void show(Object tag) {
        if (this.tempView == null) {
            throw new IllegalArgumentException("\u8981\u663e\u793a\u7684\u5f39\u7a97\u4e3a\u7a7a\uff01");
        }
        this.tempView.popupInfo = this.tempInfo;
        if (tag != null) {
            this.tempView.setTag(tag);
        }
        popupViews.add(this.tempView);
        this.tempInfo = null;
        this.tempView = null;
        for (BasePopupView pv : popupViews) {
            if (tag != null) {
                if (pv.getTag() != tag) continue;
                this.showInternal(pv);
                break;
            }
            this.showInternal(pv);
        }
    }

    public void show() {
        this.show(null);
    }

    private void showInternal(final BasePopupView pv) {
        if (pv.getParent() != null) {
            return;
        }
        Activity activity = (Activity)contextRef.get();
        this.decorView = (ViewGroup)activity.getWindow().getDecorView();
        this.decorView.addView((View)pv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.decorView.bringChildToFront((View)pv);
        pv.init(new Runnable(){

            @Override
            public void run() {
                if (pv.popupInfo.xPopupCallback != null) {
                    pv.popupInfo.xPopupCallback.onShow();
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                popupViews.remove(pv);
                if (pv.popupInfo.xPopupCallback != null) {
                    pv.popupInfo.xPopupCallback.onDismiss();
                }
                XPopup.this.decorView.removeView((View)pv);
                XPopup.this.release();
            }
        });
    }

    public void dismiss() {
        this.dismiss(null);
    }

    public void dismiss(Object tag) {
        if (tag == null) {
            popupViews.get(0).dismiss();
        } else {
            int temp = -1;
            for (int i = 0; i < popupViews.size(); ++i) {
                if (tag != popupViews.get(i).getTag()) continue;
                temp = i;
                break;
            }
            if (temp != -1) {
                popupViews.get(temp).dismiss();
            }
        }
    }

    private void release() {
        if (!popupViews.isEmpty()) {
            return;
        }
        this.handler.removeCallbacks(null);
        contextRef.clear();
        contextRef = null;
        if (this.decorView != null) {
            KeyboardUtils.removeLayoutChangeListener((View)this.decorView);
            this.decorView = null;
        }
    }

    public void setPrimaryColor(int color) {
        this.primaryColor = color;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public XPopup setPopupCallback(XPopupCallback callback) {
        this.checkPopupInfo();
        this.tempInfo.xPopupCallback = callback;
        return this;
    }

    private XPopup position(PopupType popupType) {
        this.checkPopupInfo();
        this.tempInfo.popupType = popupType;
        return this;
    }

    public XPopup popupAnimation(PopupAnimation animation) {
        this.checkPopupInfo();
        this.tempInfo.popupAnimation = animation;
        return this;
    }

    public XPopup customAnimator(PopupAnimator animator) {
        this.checkPopupInfo();
        this.tempInfo.customAnimator = animator;
        return this;
    }

    public XPopup dismissOnBackPressed(boolean isDismissOnBackPressed) {
        this.checkPopupInfo();
        this.tempInfo.isDismissOnBackPressed = isDismissOnBackPressed;
        return this;
    }

    public XPopup dismissOnTouchOutside(boolean isDismissOnTouchOutside) {
        this.checkPopupInfo();
        this.tempInfo.isDismissOnTouchOutside = isDismissOnTouchOutside;
        return this;
    }

    public XPopup atView(View view) {
        this.checkPopupInfo();
        this.tempInfo.setAtView(view);
        this.tempInfo.touchPoint = null;
        return this;
    }

    public XPopup hasShadowBg(boolean hasShadowBg) {
        this.checkPopupInfo();
        this.tempInfo.hasShadowBg = hasShadowBg;
        return this;
    }

    @Deprecated
    public XPopup setWidthAndHeight(int maxWidth, int maxHeight) {
        this.checkPopupInfo();
        this.tempInfo.maxWidth = maxWidth;
        this.tempInfo.maxHeight = maxHeight;
        return this;
    }

    public XPopup maxWidthAndHeight(int maxWidth, int maxHeight) {
        this.checkPopupInfo();
        this.tempInfo.maxWidth = maxWidth;
        this.tempInfo.maxHeight = maxHeight;
        return this;
    }

    private void checkPopupInfo() {
        if (this.tempInfo == null) {
            this.tempInfo = new PopupInfo();
        }
    }

    public XPopup watch(View view) {
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    XPopup.this.checkPopupInfo();
                    ((XPopup)XPopup.this).tempInfo.touchPoint = new PointF(event.getRawX(), event.getRawY());
                }
                return false;
            }
        });
        return this;
    }

    public XPopup asConfirm(String title, String content, OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        this.position(PopupType.Center);
        ConfirmPopupView popupView = new ConfirmPopupView((Context)contextRef.get());
        popupView.setTitleContent(title, content);
        popupView.setListener(confirmListener, cancelListener);
        this.tempView = popupView;
        return this;
    }

    public XPopup asConfirm(String title, String content, OnConfirmListener confirmListener) {
        return this.asConfirm(title, content, confirmListener, null);
    }

    public XPopup asInputConfirm(String title, String content, OnInputConfirmListener confirmListener, OnCancelListener cancelListener) {
        this.position(PopupType.Center);
        InputConfirmPopupView popupView = new InputConfirmPopupView((Context)contextRef.get());
        popupView.setTitleContent(title, content);
        popupView.setListener(confirmListener, cancelListener);
        this.tempView = popupView;
        return this;
    }

    public XPopup asInputConfirm(String title, String content, OnInputConfirmListener confirmListener) {
        return this.asInputConfirm(title, content, confirmListener, null);
    }

    public XPopup asCenterList(String title, String[] data, int[] iconIds, int checkedPosition, OnSelectListener selectListener) {
        this.position(PopupType.Center);
        this.tempView = new CenterListPopupView((Context)contextRef.get()).setStringData(title, data, iconIds).setCheckedPosition(checkedPosition).setOnSelectListener(selectListener);
        return this;
    }

    public XPopup asCenterList(String title, String[] data, OnSelectListener selectListener) {
        return this.asCenterList(title, data, null, -1, selectListener);
    }

    public XPopup asCenterList(String title, String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asCenterList(title, data, iconIds, -1, selectListener);
    }

    public XPopup asLoading(String title) {
        this.position(PopupType.Center);
        this.tempView = new LoadingPopupView((Context)contextRef.get()).setTitle(title);
        return this;
    }

    public XPopup asLoading() {
        return this.asLoading(null);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, int checkedPosition, boolean enableGesture, OnSelectListener selectListener) {
        this.position(PopupType.Bottom);
        this.tempView = new BottomListPopupView((Context)contextRef.get()).setStringData(title, data, iconIds).setCheckedPosition(checkedPosition).setOnSelectListener(selectListener).enableGesture(enableGesture);
        return this;
    }

    public XPopup asBottomList(String title, String[] data, OnSelectListener selectListener) {
        return this.asBottomList(title, data, null, -1, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, -1, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, int checkedPosition, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, checkedPosition, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, boolean enableGesture, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, -1, enableGesture, selectListener);
    }

    public XPopup asAttachList(String[] data, int[] iconIds, int offsetX, int offsetY, OnSelectListener selectListener) {
        this.position(PopupType.AttachView);
        this.tempView = new AttachListPopupView((Context)contextRef.get()).setStringData(data, iconIds).setOffsetXAndY(offsetX, offsetY).setOnSelectListener(selectListener);
        return this;
    }

    public XPopup asAttachList(String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asAttachList(data, iconIds, 0, 0, selectListener);
    }

    public XPopup asCustom(BasePopupView popupView) {
        if (popupView instanceof CenterPopupView) {
            this.position(PopupType.Center);
        } else if (popupView instanceof BottomPopupView) {
            this.position(PopupType.Bottom);
        } else if (popupView instanceof AttachPopupView) {
            this.position(PopupType.AttachView);
        } else {
            this.checkPopupInfo();
        }
        this.tempView = popupView;
        return this;
    }

    static {
        popupViews = new ArrayList();
    }
}

