/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PointF;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.core.BottomPopupView;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.enums.PopupType;
import com.lxj.xpopup.impl.AttachListPopupView;
import com.lxj.xpopup.impl.BottomListPopupView;
import com.lxj.xpopup.impl.CenterListPopupView;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.impl.InputConfirmPopupView;
import com.lxj.xpopup.impl.LoadingPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnConfirmListener;
import com.lxj.xpopup.interfaces.OnInputConfirmListener;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.interfaces.XPopupCallback;
import com.lxj.xpopup.util.KeyboardUtils;
import java.lang.ref.WeakReference;

public class XPopup
implements BasePopupView.DismissProxy {
    private static XPopup instance = null;
    private static WeakReference<Context> contextRef;
    private PopupInfo popupInfo = null;
    private Handler handler = new Handler();
    private ViewGroup activityView = null;
    private PopupStatus popupStatus = PopupStatus.Dismiss;
    private BasePopupView popupView;
    private XPopupCallback xPopupCallback;
    private int primaryColor = Color.parseColor((String)"#121212");

    private XPopup() {
    }

    public static XPopup get(Context ctx) {
        if (instance == null) {
            instance = new XPopup();
        }
        contextRef = new WeakReference<Context>(ctx);
        return instance;
    }

    public void show() {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return;
        }
        if (contextRef.get() == null) {
            throw new IllegalArgumentException("context can not be null!");
        }
        if (!(contextRef.get() instanceof Activity)) {
            throw new IllegalArgumentException("context must be an instance of Activity");
        }
        Activity activity = (Activity)contextRef.get();
        this.activityView = (ViewGroup)activity.getWindow().getDecorView();
        this.popupView.setPopupInfo(this.popupInfo);
        this.popupView.setDismissProxy(this);
        this.activityView.addView((View)this.popupView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.activityView.bringChildToFront((View)this.popupView);
        this.popupStatus = PopupStatus.Showing;
        this.popupView.init(new Runnable(){

            @Override
            public void run() {
                XPopup.this.popupStatus = PopupStatus.Show;
                if (XPopup.this.xPopupCallback != null) {
                    XPopup.this.xPopupCallback.onShow();
                }
            }
        });
        KeyboardUtils.registerSoftInputChangedListener(activity, new KeyboardUtils.OnSoftInputChangedListener(){

            @Override
            public void onSoftInputChanged(int height) {
                if (height == 0) {
                    XPopup.this.popupView.getPopupContentView().animate().translationY(0.0f).setDuration(300L).start();
                }
            }
        });
    }

    @Override
    public void dismiss() {
        if (this.popupStatus != PopupStatus.Show) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.popupView.doDismissAnimation();
        this.handler.removeCallbacks(null);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                XPopup.this.popupStatus = PopupStatus.Dismiss;
                XPopup.this.popupInfo = null;
                contextRef.clear();
                contextRef = null;
                if (XPopup.this.xPopupCallback != null) {
                    XPopup.this.xPopupCallback.onDismiss();
                }
                if (XPopup.this.activityView != null) {
                    XPopup.this.activityView.removeView((View)XPopup.this.popupView);
                    XPopup.this.activityView = null;
                }
            }
        }, (long)this.popupView.getAnimationDuration());
    }

    public void setPrimaryColor(int color) {
        this.primaryColor = color;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public XPopup setPopupCallback(XPopupCallback callback) {
        this.xPopupCallback = callback;
        return this;
    }

    private XPopup position(PopupType popupType) {
        this.checkPopupInfo();
        this.popupInfo.popupType = popupType;
        return this;
    }

    public XPopup popupAnimation(PopupAnimation animation) {
        this.checkPopupInfo();
        this.popupInfo.popupAnimation = animation;
        return this;
    }

    public XPopup customAnimator(PopupAnimator animator) {
        this.checkPopupInfo();
        this.popupInfo.customAnimator = animator;
        return this;
    }

    public XPopup dismissOnBackPressed(boolean isDismissOnBackPressed) {
        this.checkPopupInfo();
        this.popupInfo.isDismissOnBackPressed = isDismissOnBackPressed;
        return this;
    }

    public XPopup dismissOnTouchOutside(boolean isDismissOnTouchOutside) {
        this.checkPopupInfo();
        this.popupInfo.isDismissOnTouchOutside = isDismissOnTouchOutside;
        return this;
    }

    public XPopup atView(View view) {
        this.checkPopupInfo();
        this.popupInfo.setAtView(view);
        this.popupInfo.touchPoint = null;
        return this;
    }

    public XPopup hasShadowBg(boolean hasShadowBg) {
        this.checkPopupInfo();
        this.popupInfo.hasShadowBg = hasShadowBg;
        return this;
    }

    public XPopup setWidthAndHeight(int maxWidth, int maxHeight) {
        this.checkPopupInfo();
        this.popupInfo.maxWidth = maxWidth;
        this.popupInfo.maxHeight = maxHeight;
        return this;
    }

    private void checkPopupInfo() {
        if (this.popupInfo == null) {
            this.popupInfo = new PopupInfo();
        }
    }

    public XPopup watch(View view) {
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0 && XPopup.this.popupStatus == PopupStatus.Dismiss) {
                    XPopup.this.checkPopupInfo();
                    ((XPopup)XPopup.this).popupInfo.touchPoint = new PointF(event.getRawX(), event.getRawY());
                }
                return false;
            }
        });
        return this;
    }

    public XPopup asConfirm(String title, String content, OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.Center);
        ConfirmPopupView popupView = new ConfirmPopupView((Context)contextRef.get());
        popupView.setTitleContent(title, content);
        popupView.setListener(confirmListener, cancelListener);
        this.popupView = popupView;
        return this;
    }

    public XPopup asConfirm(String title, String content, OnConfirmListener confirmListener) {
        return this.asConfirm(title, content, confirmListener, null);
    }

    public XPopup asInputConfirm(String title, String content, OnInputConfirmListener confirmListener, OnCancelListener cancelListener) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.Center);
        InputConfirmPopupView popupView = new InputConfirmPopupView((Context)contextRef.get());
        popupView.setTitleContent(title, content);
        popupView.setListener(confirmListener, cancelListener);
        this.popupView = popupView;
        return this;
    }

    public XPopup asInputConfirm(String title, String content, OnInputConfirmListener confirmListener) {
        return this.asInputConfirm(title, content, confirmListener, null);
    }

    public XPopup asCenterList(String title, String[] data, int[] iconIds, int checkedPosition, OnSelectListener selectListener) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.Center);
        this.popupView = new CenterListPopupView((Context)contextRef.get()).setStringData(title, data, iconIds).setCheckedPosition(checkedPosition).setOnSelectListener(selectListener);
        return this;
    }

    public XPopup asCenterList(String title, String[] data, OnSelectListener selectListener) {
        return this.asCenterList(title, data, null, -1, selectListener);
    }

    public XPopup asCenterList(String title, String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asCenterList(title, data, iconIds, -1, selectListener);
    }

    public XPopup asLoading(String title) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.Center);
        this.popupView = new LoadingPopupView((Context)contextRef.get()).setTitle(title);
        return this;
    }

    public XPopup asLoading() {
        return this.asLoading(null);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, int checkedPosition, boolean enableGesture, OnSelectListener selectListener) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.Bottom);
        this.popupView = new BottomListPopupView((Context)contextRef.get()).setStringData(title, data, iconIds).setCheckedPosition(checkedPosition).setOnSelectListener(selectListener).enableGesture(enableGesture);
        return this;
    }

    public XPopup asBottomList(String title, String[] data, OnSelectListener selectListener) {
        return this.asBottomList(title, data, null, -1, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, -1, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, int checkedPosition, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, checkedPosition, true, selectListener);
    }

    public XPopup asBottomList(String title, String[] data, int[] iconIds, boolean enableGesture, OnSelectListener selectListener) {
        return this.asBottomList(title, data, iconIds, -1, enableGesture, selectListener);
    }

    public XPopup asAttachList(String[] data, int[] iconIds, int offsetX, int offsetY, OnSelectListener selectListener) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        this.position(PopupType.AttachView);
        this.popupView = new AttachListPopupView((Context)contextRef.get()).setStringData(data, iconIds).setOffsetXAndY(offsetX, offsetY).setOnSelectListener(selectListener);
        return this;
    }

    public XPopup asAttachList(String[] data, int[] iconIds, OnSelectListener selectListener) {
        return this.asAttachList(data, iconIds, 0, 0, selectListener);
    }

    public XPopup asCustom(BasePopupView popupView) {
        if (this.popupStatus != PopupStatus.Dismiss) {
            return this;
        }
        if (popupView instanceof CenterPopupView) {
            this.position(PopupType.Center);
        } else if (popupView instanceof BottomPopupView) {
            this.position(PopupType.Bottom);
        } else if (popupView instanceof AttachPopupView) {
            this.position(PopupType.AttachView);
        } else {
            this.checkPopupInfo();
        }
        this.popupView = popupView;
        return this;
    }
}

