/*
 * Decompiled with CFR 0.152.
 */
package com.github.library.bubbleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.github.bubbleview.R;
import com.github.library.bubbleview.BubbleDrawable;

public class BubbleLinearLayout
extends LinearLayout {
    private BubbleDrawable bubbleDrawable;
    private float mArrowWidth;
    private float mAngle;
    private float mArrowHeight;
    private float mArrowPosition;
    private BubbleDrawable.ArrowLocation mArrowLocation;
    private int bubbleColor;
    private boolean mArrowCenter;

    public BubbleLinearLayout(Context context) {
        super(context);
        this.initView(null);
    }

    public BubbleLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleView);
            this.mArrowWidth = array.getDimension(R.styleable.BubbleView_arrowWidth, BubbleDrawable.Builder.DEFAULT_ARROW_WITH);
            this.mArrowHeight = array.getDimension(R.styleable.BubbleView_arrowHeight, BubbleDrawable.Builder.DEFAULT_ARROW_HEIGHT);
            this.mAngle = array.getDimension(R.styleable.BubbleView_angle, BubbleDrawable.Builder.DEFAULT_ANGLE);
            this.mArrowPosition = array.getDimension(R.styleable.BubbleView_arrowPosition, BubbleDrawable.Builder.DEFAULT_ARROW_POSITION);
            this.bubbleColor = array.getColor(R.styleable.BubbleView_bubbleColor, BubbleDrawable.Builder.DEFAULT_BUBBLE_COLOR);
            int location = array.getInt(R.styleable.BubbleView_arrowLocation, 0);
            this.mArrowLocation = BubbleDrawable.ArrowLocation.mapIntToValue(location);
            this.mArrowCenter = array.getBoolean(R.styleable.BubbleView_arrowCenter, false);
            array.recycle();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setUp(w, h);
        }
    }

    private void setUp(int left, int right, int top, int bottom) {
        if (right < left || bottom < top) {
            return;
        }
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        this.bubbleDrawable = new BubbleDrawable.Builder().rect(rectF).arrowLocation(this.mArrowLocation).bubbleType(BubbleDrawable.BubbleType.COLOR).angle(this.mAngle).arrowHeight(this.mArrowHeight).arrowWidth(this.mArrowWidth).arrowPosition(this.mArrowPosition).bubbleColor(this.bubbleColor).arrowCenter(this.mArrowCenter).build();
    }

    private void setUp(int width, int height) {
        this.setUp(this.getPaddingLeft(), width - this.getPaddingRight(), this.getPaddingTop(), height - this.getPaddingBottom());
        this.setBackgroundDrawable(this.bubbleDrawable);
    }

    public void setUpBubbleDrawable() {
        this.setBackgroundDrawable(null);
        this.post(new Runnable(){

            @Override
            public void run() {
                BubbleLinearLayout.this.setUp(BubbleLinearLayout.this.getWidth(), BubbleLinearLayout.this.getHeight());
            }
        });
    }
}

