/*
 * Decompiled with CFR 0.152.
 */
package com.github.library.bubbleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.github.bubbleview.R;
import com.github.library.bubbleview.BubbleDrawable;

public class BubbleImageView
extends ImageView {
    private BubbleDrawable bubbleDrawable;
    private Drawable sourceDrawable;
    private float mArrowWidth;
    private float mAngle;
    private float mArrowHeight;
    private float mArrowPosition;
    private Bitmap mBitmap;
    private BubbleDrawable.ArrowLocation mArrowLocation;
    private boolean mArrowCenter;

    public BubbleImageView(Context context) {
        super(context);
        this.initView(null);
    }

    public BubbleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public BubbleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleView);
            this.mArrowWidth = array.getDimension(R.styleable.BubbleView_arrowWidth, BubbleDrawable.Builder.DEFAULT_ARROW_WITH);
            this.mArrowHeight = array.getDimension(R.styleable.BubbleView_arrowHeight, BubbleDrawable.Builder.DEFAULT_ARROW_HEIGHT);
            this.mAngle = array.getDimension(R.styleable.BubbleView_angle, BubbleDrawable.Builder.DEFAULT_ANGLE);
            this.mArrowPosition = array.getDimension(R.styleable.BubbleView_arrowPosition, BubbleDrawable.Builder.DEFAULT_ARROW_POSITION);
            int location = array.getInt(R.styleable.BubbleView_arrowLocation, 0);
            this.mArrowLocation = BubbleDrawable.ArrowLocation.mapIntToValue(location);
            this.mArrowCenter = array.getBoolean(R.styleable.BubbleView_arrowCenter, false);
            array.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (width <= 0 && height > 0) {
            this.setMeasuredDimension(height, height);
        }
        if (height <= 0 && width > 0) {
            this.setMeasuredDimension(width, width);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setUp(w, h);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setUp();
    }

    protected void onDraw(Canvas canvas) {
        int saveCount = canvas.getSaveCount();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        if (this.bubbleDrawable != null) {
            this.bubbleDrawable.draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    private void setUp(int left, int right, int top, int bottom) {
        if (right <= left || bottom <= top) {
            return;
        }
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        if (this.sourceDrawable != null) {
            this.mBitmap = this.getBitmapFromDrawable(this.sourceDrawable);
        }
        this.bubbleDrawable = new BubbleDrawable.Builder().rect(rectF).arrowLocation(this.mArrowLocation).angle(this.mAngle).arrowHeight(this.mArrowHeight).arrowWidth(this.mArrowWidth).bubbleType(BubbleDrawable.BubbleType.BITMAP).arrowPosition(this.mArrowPosition).bubbleBitmap(this.mBitmap).arrowCenter(this.mArrowCenter).build();
    }

    private void setUp(int width, int height) {
        this.setUp(this.getPaddingLeft(), width - this.getPaddingRight(), this.getPaddingTop(), height - this.getPaddingBottom());
    }

    private void setUp() {
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height <= 0 && this.sourceDrawable != null && this.sourceDrawable.getIntrinsicWidth() >= 0) {
            scale = width / this.sourceDrawable.getIntrinsicWidth();
            height = scale * this.sourceDrawable.getIntrinsicHeight();
        }
        if (height > 0 && width <= 0 && this.sourceDrawable != null && this.sourceDrawable.getIntrinsicHeight() >= 0) {
            scale = height / this.sourceDrawable.getIntrinsicHeight();
            width = scale * this.sourceDrawable.getIntrinsicWidth();
        }
        this.setUp(width, height);
    }

    public void setImageBitmap(Bitmap mBitmap) {
        if (mBitmap == null) {
            return;
        }
        this.mBitmap = mBitmap;
        this.sourceDrawable = new BitmapDrawable(this.getResources(), mBitmap);
        this.setUp();
        super.setImageDrawable((Drawable)this.bubbleDrawable);
    }

    public void setImageDrawable(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        this.sourceDrawable = drawable;
        this.setUp();
        super.setImageDrawable((Drawable)this.bubbleDrawable);
    }

    public void setImageResource(int res) {
        this.setImageDrawable(this.getDrawable(res));
    }

    private Drawable getDrawable(int res) {
        if (res == 0) {
            throw new IllegalArgumentException("getDrawable res can not be zero");
        }
        return this.getContext().getResources().getDrawable(res);
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        return BubbleImageView.getBitmapFromDrawable(this.getContext(), drawable, this.getWidth(), this.getWidth(), 25);
    }

    public static Bitmap getBitmapFromDrawable(Context mContext, Drawable drawable, int width, int height, int defaultSize) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = width > 0 && height > 0 ? Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)BubbleImageView.dp2px(mContext, defaultSize), (int)BubbleImageView.dp2px(mContext, defaultSize), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    public static int dp2px(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

