/*
 * Decompiled with CFR 0.152.
 */
package com.github.lguipeng.library.animcheckbox;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.Checkable;
import com.github.lguipeng.library.R;

public class AnimCheckBox
extends View
implements Checkable {
    private final double mSin27 = Math.sin(Math.toRadians(27.0));
    private final double mSin63 = Math.sin(Math.toRadians(63.0));
    private final int mDuration = 500;
    private final int defaultSize = 40;
    private Paint mPaint = new Paint(1);
    private int radius;
    private RectF mRectF = new RectF();
    private RectF mInnerRectF = new RectF();
    private Path mPath = new Path();
    private float mSweepAngle;
    private float mHookStartY;
    private float mBaseLeftHookOffset;
    private float mBaseRightHookOffset;
    private float mEndLeftHookOffset;
    private float mEndRightHookOffset;
    private int size;
    private boolean mChecked;
    private float mHookOffset;
    private float mHookSize;
    private int mInnerCircleAlpha = 255;
    private int mStrokeWidth = 2;
    private int mStrokeColor = -16776961;
    private int mCircleColor = -1;
    private OnCheckedChangeListener mOnCheckedChangeListener;

    public AnimCheckBox(Context context) {
        this(context, null);
    }

    public AnimCheckBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        boolean checked = this.mChecked;
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.AnimCheckBox);
            this.mStrokeWidth = (int)array.getDimension(R.styleable.AnimCheckBox_stroke_width, (float)this.dip(this.mStrokeWidth));
            this.mStrokeColor = array.getColor(R.styleable.AnimCheckBox_stroke_color, this.mStrokeColor);
            this.mCircleColor = array.getColor(R.styleable.AnimCheckBox_circle_color, -1);
            checked = array.getBoolean(R.styleable.AnimCheckBox_checked, false);
            array.recycle();
        } else {
            this.mStrokeWidth = this.dip(this.mStrokeWidth);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mPaint.setColor(this.mStrokeColor);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AnimCheckBox.this.setChecked(!AnimCheckBox.this.mChecked);
            }
        });
        this.setCheckedViewInner(checked, false);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE && View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            width = height = Math.min(this.dip(40) - params.leftMargin - params.rightMargin, this.dip(40) - params.bottomMargin - params.topMargin);
        }
        int size = Math.min(width - this.getPaddingLeft() - this.getPaddingRight(), height - this.getPaddingBottom() - this.getPaddingTop());
        this.setMeasuredDimension(size, size);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.size = this.getWidth();
        this.radius = (this.getWidth() - 2 * this.mStrokeWidth) / 2;
        this.mRectF.set((float)this.mStrokeWidth, (float)this.mStrokeWidth, (float)(this.size - this.mStrokeWidth), (float)(this.size - this.mStrokeWidth));
        this.mInnerRectF.set(this.mRectF);
        this.mInnerRectF.inset((float)(this.mStrokeWidth / 2), (float)(this.mStrokeWidth / 2));
        this.mHookStartY = (float)((double)(this.size / 2) - ((double)this.radius * this.mSin27 + ((double)this.radius - (double)this.radius * this.mSin63)));
        this.mBaseLeftHookOffset = (float)((double)this.radius * (1.0 - this.mSin63)) + (float)(this.mStrokeWidth / 2);
        this.mBaseRightHookOffset = 0.0f;
        this.mEndLeftHookOffset = this.mBaseLeftHookOffset + ((float)(2 * this.size / 3) - this.mHookStartY) * 0.33f;
        this.mEndRightHookOffset = this.mBaseRightHookOffset + ((float)(this.size / 3) + this.mHookStartY) * 0.38f;
        this.mHookSize = (float)this.size - (this.mEndLeftHookOffset + this.mEndRightHookOffset);
        this.mHookOffset = this.mChecked ? this.mHookSize + this.mEndLeftHookOffset - this.mBaseLeftHookOffset : 0.0f;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircle(canvas);
        this.drawHook(canvas);
    }

    private void drawCircle(Canvas canvas) {
        this.initDrawStrokeCirclePaint();
        canvas.drawArc(this.mRectF, 202.0f, this.mSweepAngle, false, this.mPaint);
        this.initDrawAlphaStrokeCirclePaint();
        canvas.drawArc(this.mRectF, 202.0f, this.mSweepAngle - 360.0f, false, this.mPaint);
        this.initDrawInnerCirclePaint();
        canvas.drawArc(this.mInnerRectF, 0.0f, 360.0f, false, this.mPaint);
    }

    private void drawHook(Canvas canvas) {
        if (this.mHookOffset == 0.0f) {
            return;
        }
        this.initDrawHookPaint();
        this.mPath.reset();
        if (this.mHookOffset <= (float)(2 * this.size / 3) - this.mHookStartY - this.mBaseLeftHookOffset) {
            this.mPath.moveTo(this.mBaseLeftHookOffset, this.mBaseLeftHookOffset + this.mHookStartY);
            this.mPath.lineTo(this.mBaseLeftHookOffset + this.mHookOffset, this.mBaseLeftHookOffset + this.mHookStartY + this.mHookOffset);
        } else if (this.mHookOffset <= this.mHookSize) {
            this.mPath.moveTo(this.mBaseLeftHookOffset, this.mBaseLeftHookOffset + this.mHookStartY);
            this.mPath.lineTo((float)(2 * this.size / 3) - this.mHookStartY, (float)(2 * this.size / 3));
            this.mPath.lineTo(this.mHookOffset + this.mBaseLeftHookOffset, (float)(2 * this.size / 3) - (this.mHookOffset - ((float)(2 * this.size / 3) - this.mHookStartY - this.mBaseLeftHookOffset)));
        } else {
            float offset = this.mHookOffset - this.mHookSize;
            this.mPath.moveTo(this.mBaseLeftHookOffset + offset, this.mBaseLeftHookOffset + this.mHookStartY + offset);
            this.mPath.lineTo((float)(2 * this.size / 3) - this.mHookStartY, (float)(2 * this.size / 3));
            this.mPath.lineTo(this.mHookSize + this.mBaseLeftHookOffset + offset, (float)(2 * this.size / 3) - (this.mHookSize - ((float)(2 * this.size / 3) - this.mHookStartY - this.mBaseLeftHookOffset) + offset));
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void initDrawHookPaint() {
        this.mPaint.setAlpha(255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mPaint.setColor(this.mStrokeColor);
    }

    private void initDrawStrokeCirclePaint() {
        this.mPaint.setAlpha(255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mPaint.setColor(this.mStrokeColor);
    }

    private void initDrawAlphaStrokeCirclePaint() {
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mStrokeColor);
        this.mPaint.setAlpha(64);
    }

    private void initDrawInnerCirclePaint() {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mCircleColor);
        this.mPaint.setAlpha(this.mInnerCircleAlpha);
    }

    private void startCheckedAnim() {
        ValueAnimator animator = new ValueAnimator();
        final float hookMaxValue = this.mHookSize + this.mEndLeftHookOffset - this.mBaseLeftHookOffset;
        final float circleMaxFraction = this.mHookSize / hookMaxValue;
        final float circleMaxValue = 360.0f / circleMaxFraction;
        animator.setFloatValues(new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                AnimCheckBox.this.mHookOffset = fraction * hookMaxValue;
                if (fraction <= circleMaxFraction) {
                    AnimCheckBox.this.mSweepAngle = (int)((circleMaxFraction - fraction) * circleMaxValue);
                } else {
                    AnimCheckBox.this.mSweepAngle = 0.0f;
                }
                AnimCheckBox.this.mInnerCircleAlpha = (int)(fraction * 255.0f);
                AnimCheckBox.this.invalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.setDuration(500L).start();
    }

    private void startUnCheckedAnim() {
        ValueAnimator animator = new ValueAnimator();
        final float hookMaxValue = this.mHookSize + this.mEndLeftHookOffset - this.mBaseLeftHookOffset;
        final float circleMinFraction = (this.mEndLeftHookOffset - this.mBaseLeftHookOffset) / hookMaxValue;
        final float circleMaxValue = 360.0f / (1.0f - circleMinFraction);
        animator.setFloatValues(new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float circleFraction = animation.getAnimatedFraction();
                float fraction = 1.0f - circleFraction;
                AnimCheckBox.this.mHookOffset = fraction * hookMaxValue;
                if (circleFraction >= circleMinFraction) {
                    AnimCheckBox.this.mSweepAngle = (int)((circleFraction - circleMinFraction) * circleMaxValue);
                } else {
                    AnimCheckBox.this.mSweepAngle = 0.0f;
                }
                AnimCheckBox.this.mInnerCircleAlpha = (int)(fraction * 255.0f);
                AnimCheckBox.this.invalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.setDuration(500L).start();
    }

    private void startAnim() {
        this.clearAnimation();
        if (this.mChecked) {
            this.startCheckedAnim();
        } else {
            this.startUnCheckedAnim();
        }
    }

    private int getAlphaColor(int color, int alpha) {
        alpha = alpha < 0 ? 0 : alpha;
        alpha = alpha > 255 ? 255 : alpha;
        return color & 0xFFFFFF | alpha << 24;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, true);
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean checked, boolean animation) {
        if (checked == this.mChecked) {
            return;
        }
        this.setCheckedViewInner(checked, animation);
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onChange(this, this.mChecked);
        }
    }

    @Deprecated
    public void setOnClickListener(View.OnClickListener l) {
    }

    private void setCheckedViewInner(boolean checked, boolean animation) {
        this.mChecked = checked;
        if (animation) {
            this.startAnim();
        } else {
            if (this.mChecked) {
                this.mInnerCircleAlpha = 255;
                this.mSweepAngle = 0.0f;
                this.mHookOffset = this.mHookSize + this.mEndLeftHookOffset - this.mBaseLeftHookOffset;
            } else {
                this.mInnerCircleAlpha = 0;
                this.mSweepAngle = 360.0f;
                this.mHookOffset = 0.0f;
            }
            this.invalidate();
        }
    }

    private int dip(int dip) {
        return (int)this.getContext().getResources().getDisplayMetrics().density * dip;
    }

    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public static interface OnCheckedChangeListener {
        public void onChange(AnimCheckBox var1, boolean var2);
    }
}

