/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgdd.liferay.health;

import com.github.lgdd.liferay.health.BundlesHealthCheck;
import com.github.lgdd.liferay.health.ComponentsHealthCheck;
import com.github.lgdd.liferay.health.HealthCheckConfiguration;
import com.github.lgdd.liferay.health.HealthCheckProbeType;
import com.github.lgdd.liferay.health.api.HealthCheckResponse;
import com.github.lgdd.liferay.health.api.HealthCheckStatus;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.jaxrs.application.base=/health", "osgi.jaxrs.name=Health", "oauth2.scopechecker.type=none", "liferay.access.control.disable=true"}, configurationPid={"com.github.lgdd.liferay.health.HealthCheckConfiguration"}, service={Application.class})
public class HealthCheck
extends Application {
    private volatile HealthCheckConfiguration _config;
    @Reference
    private ComponentsHealthCheck _componentsHealthCheck;
    @Reference
    private BundlesHealthCheck _bundlesHealthCheck;

    @GET
    @Path(value="/readiness")
    @Produces(value={"application/json"})
    public Response readiness() {
        return this._verifyRequiredBundles(HealthCheckProbeType.READINESS, this._config.bundleSymbolicNamesForReadiness(), this._config.verifyBundlesStatesForReadiness());
    }

    @GET
    @Path(value="/liveness")
    @Produces(value={"application/json"})
    public Response liveness() {
        return this._verifyRequiredBundles(HealthCheckProbeType.LIVENESS, this._config.bundleSymbolicNamesForLiveness(), this._config.verifyBundlesStatesForLiveness());
    }

    private Response _verifyRequiredBundles(HealthCheckProbeType probeType, String[] requiredBundleSymbolicNames, boolean isVerificationRequired) {
        HealthCheckResponse requiredBundlesResponse;
        Set<String> bundleSymbolicNames = Arrays.stream(requiredBundleSymbolicNames).filter(symbolicName -> !symbolicName.trim().isEmpty()).collect(Collectors.toSet());
        if (!bundleSymbolicNames.isEmpty() && HealthCheckStatus.DOWN.equals((Object)(requiredBundlesResponse = this._bundlesHealthCheck.verifyBundles(probeType, bundleSymbolicNames)).getStatus())) {
            return Response.serverError().entity((Object)requiredBundlesResponse.toJson()).build();
        }
        return this._verifyBundlesStates(isVerificationRequired);
    }

    private Response _verifyBundlesStates(boolean hasToVerifyBundlesStates) {
        HealthCheckResponse bundlesResponse;
        if (hasToVerifyBundlesStates && HealthCheckStatus.DOWN.equals((Object)(bundlesResponse = this._bundlesHealthCheck.verify()).getStatus())) {
            return Response.serverError().entity((Object)bundlesResponse.toJson()).build();
        }
        return this._verifyComponents();
    }

    private Response _verifyComponents() {
        HealthCheckResponse componentsResponse = this._componentsHealthCheck.verify();
        if (HealthCheckStatus.DOWN.equals((Object)componentsResponse.getStatus())) {
            return Response.serverError().entity((Object)componentsResponse.toJson()).build();
        }
        return Response.ok((Object)componentsResponse.toJson()).build();
    }

    public Set<Object> getSingletons() {
        return Collections.singleton(this);
    }

    @Activate
    @Modified
    public void activate(Map<String, String> properties) {
        this._config = (HealthCheckConfiguration)ConfigurableUtil.createConfigurable(HealthCheckConfiguration.class, properties);
    }
}

