/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgdd.liferay.health;

import com.github.lgdd.liferay.health.api.HealthCheckResponse;
import com.github.lgdd.liferay.health.api.HealthCheckStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.diagnostics.DependencyGraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ComponentsHealthCheck.class})
public class ComponentsHealthCheck {
    public static final String OK_MESSAGE = "No unregistered components found";
    private static final Logger _log = LoggerFactory.getLogger(ComponentsHealthCheck.class);

    public HealthCheckResponse verify() {
        ArrayList<String> issues = new ArrayList<String>();
        HealthCheckStatus status = HealthCheckStatus.UP;
        String message = OK_MESSAGE;
        DependencyGraph graph = DependencyGraph.getGraph((DependencyGraph.ComponentState)DependencyGraph.ComponentState.UNREGISTERED, (DependencyGraph.DependencyState)DependencyGraph.DependencyState.REQUIRED_UNAVAILABLE);
        List unregisteredComponents = graph.getAllComponents();
        if (!unregisteredComponents.isEmpty()) {
            status = HealthCheckStatus.DOWN;
            message = unregisteredComponents.size() + " unregistered components found";
            _log.warn(message);
            for (ComponentDeclaration componentDeclaration : unregisteredComponents) {
                Bundle bundle;
                BundleContext bundleContext = componentDeclaration.getBundleContext();
                if (bundleContext == null || (bundle = bundleContext.getBundle()) == null) continue;
                _log.warn("Found unregistered component " + componentDeclaration.getName() + " in bundle: " + bundle.getSymbolicName());
                issues.add("Unregistered component " + componentDeclaration.getName() + " in bundle: " + bundle.getSymbolicName());
            }
        }
        return HealthCheckResponse.builder().status(status).message(message).issues(issues).build();
    }
}

