/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgdd.liferay.health;

import com.github.lgdd.liferay.health.HealthCheckProbeType;
import com.github.lgdd.liferay.health.api.HealthCheckResponse;
import com.github.lgdd.liferay.health.api.HealthCheckService;
import com.github.lgdd.liferay.health.api.HealthCheckStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.dm.diagnostics.CircularDependency;
import org.apache.felix.dm.diagnostics.DependencyGraph;
import org.apache.felix.dm.diagnostics.MissingDependency;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={BundlesHealthCheck.class})
public class BundlesHealthCheck {
    private ServiceTracker<HealthCheckService, HealthCheckService> individualBundleHealthCheckServiceTracker;
    private BundleContext _context;
    private static final Logger _log = LoggerFactory.getLogger(BundlesHealthCheck.class);

    public HealthCheckResponse verify() {
        String message = "No issues with bundles";
        List<String> issues = this._getIssues();
        if (issues.isEmpty()) {
            return HealthCheckResponse.builder().status(HealthCheckStatus.UP).message(message).build();
        }
        message = issues.size() > 1 ? "Found " + issues.size() + " issues with bundles" : "Found 1 issue with bundles";
        return HealthCheckResponse.builder().status(HealthCheckStatus.DOWN).message(message).issues(issues).build();
    }

    public HealthCheckResponse verifyBundles(HealthCheckProbeType probeType, Set<String> requiredBundleSymbolicNames) {
        String message = "No issues with bundles";
        List<String> issues = new ArrayList<String>();
        Set<Bundle> bundlesFound = Arrays.stream(this._context.getBundles()).filter(bundle -> requiredBundleSymbolicNames.contains(bundle.getSymbolicName())).collect(Collectors.toSet());
        HealthCheckResponse individualBundleHealthResponse = this._checkIndividualBundleHealth(probeType, bundlesFound);
        if (HealthCheckStatus.DOWN.equals((Object)individualBundleHealthResponse.getStatus())) {
            return individualBundleHealthResponse;
        }
        if (bundlesFound.size() != requiredBundleSymbolicNames.size()) {
            message = "Found " + bundlesFound.size() + " out of " + requiredBundleSymbolicNames.size() + " bundles required by the configuration";
            Set bundleFoundSymbolicNames = bundlesFound.stream().map(Bundle::getSymbolicName).collect(Collectors.toSet());
            issues = requiredBundleSymbolicNames.stream().filter(symbolicName -> !bundleFoundSymbolicNames.contains(symbolicName)).map(symbolicName -> "Bundle [" + symbolicName + "] was not found.").collect(Collectors.toList());
            return HealthCheckResponse.builder().status(HealthCheckStatus.DOWN).message(message).issues(issues).build();
        }
        issues.addAll(this._listResolvedBundles(this._context.getBundles()));
        issues.addAll(this._listInstalledBundles(this._context.getBundles()));
        if (!issues.isEmpty()) {
            message = "Found some required bundles in an undesired state.";
            return HealthCheckResponse.builder().status(HealthCheckStatus.DOWN).message(message).issues(issues).build();
        }
        return HealthCheckResponse.builder().status(HealthCheckStatus.UP).message(message).issues(issues).build();
    }

    private HealthCheckResponse _checkIndividualBundleHealth(HealthCheckProbeType probeType, Set<Bundle> bundles) {
        ArrayList downList = new ArrayList();
        ArrayList<String> issues = new ArrayList<String>();
        ServiceReference[] serviceReferences = this.individualBundleHealthCheckServiceTracker.getServiceReferences();
        Arrays.stream(serviceReferences).forEach(serviceReference -> {
            Bundle observedBundle = serviceReference.getBundle();
            if (bundles.contains(observedBundle)) {
                HealthCheckService healthCheckService = (HealthCheckService)this.individualBundleHealthCheckServiceTracker.getService(serviceReference);
                String symbolicName = serviceReference.getBundle().getSymbolicName();
                HealthCheckResponse healthCheckResponse = this._getIndividualBundleHealthCheckResponse(probeType, healthCheckService);
                if (HealthCheckStatus.DOWN.equals((Object)healthCheckResponse.getStatus())) {
                    _log.warn("Bundle [" + symbolicName + "] declares being DOWN with following issues:");
                    healthCheckResponse.getIssues().forEach(arg_0 -> ((Logger)_log).warn(arg_0));
                    issues.addAll(healthCheckResponse.getIssues());
                    downList.add(HealthCheckStatus.DOWN);
                } else {
                    _log.info("Bundle [" + symbolicName + "] declares being UP");
                }
            }
        });
        if (!downList.isEmpty()) {
            String message = String.format("%d out of %d declares being down.", downList.size(), serviceReferences.length);
            return HealthCheckResponse.builder().message(message).status(HealthCheckStatus.DOWN).issues(issues).build();
        }
        return HealthCheckResponse.builder().message("No issue from custom health checks").status(HealthCheckStatus.UP).build();
    }

    private HealthCheckResponse _getIndividualBundleHealthCheckResponse(HealthCheckProbeType probeType, HealthCheckService healthCheckService) {
        if (HealthCheckProbeType.READINESS.equals((Object)probeType)) {
            return healthCheckService.isReady();
        }
        return healthCheckService.isLive();
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._context = bundleContext;
        this.individualBundleHealthCheckServiceTracker = new ServiceTracker(this._context, HealthCheckService.class, null);
        this.individualBundleHealthCheckServiceTracker.open();
    }

    @Deactivate
    public void deactivate() {
        this.individualBundleHealthCheckServiceTracker.close();
    }

    private List<String> _getIssues() {
        List missingCustomDependencies;
        List missingBundleDependencies;
        List missingResourceDependencies;
        List missingServiceDependencies;
        List missingConfigDependencies;
        ArrayList<String> issues = new ArrayList<String>();
        DependencyGraph graph = DependencyGraph.getGraph((DependencyGraph.ComponentState)DependencyGraph.ComponentState.UNREGISTERED, (DependencyGraph.DependencyState)DependencyGraph.DependencyState.REQUIRED_UNAVAILABLE);
        issues.addAll(this._listResolvedBundles(this._context.getBundles()));
        issues.addAll(this._listInstalledBundles(this._context.getBundles()));
        List circularDependencies = graph.getCircularDependencies();
        if (!circularDependencies.isEmpty()) {
            _log.warn("Circular dependencies:");
            issues.addAll(this._getCircularDependenciesIssues(circularDependencies));
        }
        if (!(missingConfigDependencies = graph.getMissingDependencies("configuration")).isEmpty()) {
            _log.warn("The following configuration(s) are missing: ");
            issues.addAll(this._getMissingDependenciesIssues(missingConfigDependencies));
        }
        if (!(missingServiceDependencies = graph.getMissingDependencies("service")).isEmpty()) {
            _log.warn("The following service(s) are missing: ");
            issues.addAll(this._getMissingDependenciesIssues(missingServiceDependencies));
        }
        if (!(missingResourceDependencies = graph.getMissingDependencies("resource")).isEmpty()) {
            _log.warn("The following resource(s) are missing: ");
            issues.addAll(this._getMissingDependenciesIssues(missingResourceDependencies));
        }
        if (!(missingBundleDependencies = graph.getMissingDependencies("bundle")).isEmpty()) {
            _log.warn("The following bundle(s) are missing: ");
            issues.addAll(this._getMissingDependenciesIssues(missingBundleDependencies));
        }
        if (!(missingCustomDependencies = graph.getMissingCustomDependencies()).isEmpty()) {
            _log.warn("The following custom dependency(ies) are missing: ");
            issues.addAll(this._getMissingCustomDependenciesIssues(missingCustomDependencies));
        }
        return issues;
    }

    private List<String> _getCircularDependenciesIssues(List<CircularDependency> circularDependencies) {
        ArrayList<String> issues = new ArrayList<String>();
        circularDependencies.forEach(c -> {
            _log.warn(" *");
            c.getComponents().forEach(cd -> {
                _log.warn(" -> " + cd.getName());
                issues.add(cd.getName());
            });
        });
        return issues;
    }

    private List<String> _getMissingDependenciesIssues(List<MissingDependency> missingDependencies) {
        ArrayList<String> issues = new ArrayList<String>();
        missingDependencies.forEach(m -> {
            _log.warn(" * " + m.getName() + " for bundle " + m.getBundleName());
            issues.add("Missing dependency " + m.getName() + " for bundle " + m.getBundleName());
        });
        return issues;
    }

    private List<String> _getMissingCustomDependenciesIssues(List<MissingDependency> missingDependencies) {
        ArrayList<String> issues = new ArrayList<String>();
        missingDependencies.forEach(m -> {
            _log.warn(" * " + m.getName() + "(" + m.getType() + ") for bundle " + m.getBundleName());
            issues.add("Missing custom dependency " + m.getName() + "(" + m.getType() + ") for bundle " + m.getBundleName());
        });
        return issues;
    }

    private List<String> _listResolvedBundles(Bundle[] bundles) {
        ArrayList<String> resolveBundleNames = new ArrayList<String>();
        boolean areResolved = false;
        for (Bundle b : bundles) {
            if (b.getState() != 4 || this._isFragment(b)) continue;
            areResolved = true;
            break;
        }
        if (areResolved) {
            _log.warn("Please note that the following bundles are in the RESOLVED state:");
            for (Bundle b : bundles) {
                if (b.getState() != 4 || this._isFragment(b)) continue;
                resolveBundleNames.add("[" + b.getBundleId() + "] " + b.getSymbolicName() + " is RESOLVED");
                _log.warn(" * [{}] {}", (Object)b.getBundleId(), (Object)b.getSymbolicName());
            }
        }
        return resolveBundleNames;
    }

    private List<String> _listInstalledBundles(Bundle[] bundles) {
        ArrayList<String> installedBundles = new ArrayList<String>();
        boolean areInstalled = false;
        for (Bundle b : bundles) {
            if (b.getState() != 2) continue;
            areInstalled = true;
            break;
        }
        if (areInstalled) {
            _log.warn("Please note that the following bundles are in the INSTALLED state:");
            for (Bundle b : bundles) {
                if (b.getState() != 2) continue;
                installedBundles.add("[" + b.getBundleId() + "] " + b.getSymbolicName() + " is INSTALLED");
                _log.warn(" * [{}] {}", (Object)b.getBundleId(), (Object)b.getSymbolicName());
            }
        }
        return installedBundles;
    }

    private boolean _isFragment(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Fragment-Host") != null;
    }
}

