/*
 * Decompiled with CFR 0.152.
 */
package com.testautomationguru.ocular.snapshot;

import com.testautomationguru.ocular.Ocular;
import com.testautomationguru.ocular.exception.OcularException;
import com.testautomationguru.ocular.sample.SampleBuilder;
import com.testautomationguru.ocular.sample.SampleBuilderImpl;
import com.testautomationguru.ocular.snapshot.Snap;
import com.testautomationguru.ocular.snapshot.SnapshotAttributes;
import com.testautomationguru.ocular.snapshot.SnapshotBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SnapshotBuilderImpl
implements SnapshotBuilder {
    private SnapshotAttributes snapshotAttribute = new SnapshotAttributes();

    @Override
    public <T> SnapshotBuilder from(Class<T> pageClass) {
        this.getSnapAnnotation(pageClass);
        return this;
    }

    @Override
    public SnapshotBuilder from(Object object) {
        this.getSnapAnnotation(object.getClass());
        return this;
    }

    @Override
    public SnapshotBuilder from(Path path) {
        this.resolvePath(path);
        return this;
    }

    @Override
    public SnapshotBuilder replaceAttribute(String param, String value) {
        String newPath = this.snapshotAttribute.getSnapshotPath().toString().replaceAll("#\\{" + param + "}", value);
        this.snapshotAttribute.setSnapshotPath(Paths.get(newPath, new String[0]));
        return this;
    }

    @Override
    public SampleBuilder sample() {
        int similarity;
        int n = similarity = this.snapshotAttribute.getSimilarity() > -1 ? this.snapshotAttribute.getSimilarity() : Ocular.config().getGlobalSimilarity();
        if (similarity < 0 || similarity > 100) {
            throw new IllegalArgumentException("Similarity should be between 0 and 100. But the actual is " + similarity);
        }
        this.snapshotAttribute.setSimilarity(similarity);
        return new SampleBuilderImpl(this.snapshotAttribute);
    }

    private void getSnapAnnotation(Class<?> klass) {
        if (!klass.isAnnotationPresent(Snap.class)) {
            throw new OcularException("Snap annotation is not present for type : " + klass.getName());
        }
        Snap snap = klass.getAnnotation(Snap.class);
        this.snapshotAttribute.setSimilarity(snap.similarity());
        this.resolvePath(Paths.get(snap.value(), new String[0]));
    }

    private void resolvePath(Path path) {
        path = path.isAbsolute() ? path : Ocular.config().getSnapshotPath().resolve(path);
        this.snapshotAttribute.setSnapshotPath(path);
    }
}

