/*
 * Decompiled with CFR 0.152.
 */
package com.testautomationguru.ocular.comparator;

import org.arquillian.rusheye.suite.ComparisonResult;

public class OcularResult
extends ComparisonResult {
    private final int similarityCutOff;

    public OcularResult(ComparisonResult result, int similarityCutOff) {
        super.setArea(result.getArea());
        super.setEqualsImages(result.isEqualsImages());
        super.setDiffImage(result.getDiffImage());
        super.setTotalPixels(result.getTotalPixels());
        super.setMaskedPixels(result.getMaskedPixels());
        super.setPerceptibleDiffs(result.getPerceptibleDiffs());
        super.setDifferentPixels(result.getDifferentPixels());
        super.setSmallDifferences(result.getSmallDifferences());
        super.setEqualPixels(result.getEqualPixels());
        this.similarityCutOff = similarityCutOff;
    }

    public boolean isEqualsImages() {
        if (super.isEqualsImages()) {
            return true;
        }
        if (this.getPerceptibleDiffs() == 0) {
            return true;
        }
        return this.getSimilarity() >= this.similarityCutOff;
    }

    public int getSimilarity() {
        return this.getEqualPixels() * 100 / this.getTotalPixels();
    }

    public String toString() {
        return "OcularResult [equalsImages=" + this.isEqualsImages() + ", totalPixels=" + this.getTotalPixels() + ", maskedPixels=" + this.getMaskedPixels() + ", perceptibleDiffs=" + this.getPerceptibleDiffs() + ", differentPixels=" + this.getDifferentPixels() + ", smallDifferences=" + this.getSmallDifferences() + ", equalPixels=" + this.getEqualPixels() + ", similarity=" + this.getSimilarity() + "]";
    }
}

