/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtil {
    private static Pattern SPECIAL_CHAR_WHITESPACE = Pattern.compile("(&[a-z]*;|&#x?([a-f]|[A-F]|[0-9])*;|[\\s\n]+)");
    private static Pattern SPECIAL_CHAR_NO_WHITESPACE = Pattern.compile("(&[a-z]*;|&#x?([a-f]|[A-F]|[0-9])*;)");
    private static Map<String, String> REPLACEMENTS = new HashMap<String, String>();

    public static String replaceHtmlEntities(String aText, boolean preserveFormatting) {
        Matcher matcher;
        StringBuffer result = new StringBuffer();
        HashMap<String, String> replacements = new HashMap<String, String>(REPLACEMENTS);
        if (preserveFormatting) {
            matcher = SPECIAL_CHAR_NO_WHITESPACE.matcher(aText);
        } else {
            matcher = SPECIAL_CHAR_WHITESPACE.matcher(aText);
            replacements.put("", " ");
            replacements.put("\n", " ");
        }
        while (matcher.find()) {
            try {
                matcher.appendReplacement(result, TextUtil.getReplacement(matcher, replacements));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String getReplacement(Matcher aMatcher, Map<String, String> replacements) {
        String match = aMatcher.group(0).trim();
        String result = replacements.get(match);
        if (result != null) {
            return result;
        }
        if (match.startsWith("&#")) {
            try {
                Integer code = match.startsWith("&#x") ? Integer.decode("0x" + match.substring(3, match.length() - 1)) : Integer.valueOf(Integer.parseInt(match.substring(2, match.length() - 1)));
                return "" + (char)code.intValue();
            }
            catch (NumberFormatException nfe) {
                return "";
            }
        }
        return "";
    }

    static {
        REPLACEMENTS.put("&nbsp;", "\u00a0");
        REPLACEMENTS.put("&amp;", "&");
        REPLACEMENTS.put("&quot;", "\"");
        REPLACEMENTS.put("&cent;", "\u00a2");
        REPLACEMENTS.put("&lt;", "<");
        REPLACEMENTS.put("&gt;", ">");
        REPLACEMENTS.put("&sect;", "\u00a7");
        REPLACEMENTS.put("&ldquo;", "\u201c");
        REPLACEMENTS.put("&rdquo;", "\u201d");
        REPLACEMENTS.put("&lsquo;", "\u2018");
        REPLACEMENTS.put("&rsquo;", "\u2019");
        REPLACEMENTS.put("&ndash;", "\u2013");
        REPLACEMENTS.put("&mdash;", "\u2014");
        REPLACEMENTS.put("&horbar;", "\u2015");
        REPLACEMENTS.put("&apos;", "'");
        REPLACEMENTS.put("&iexcl;", "\u00a1");
        REPLACEMENTS.put("&pound;", "\u00a3");
        REPLACEMENTS.put("&curren;", "\u00a4");
        REPLACEMENTS.put("&yen;", "\u00a5");
        REPLACEMENTS.put("&brvbar;", "\u00a6");
        REPLACEMENTS.put("&uml;", "\u00a8");
        REPLACEMENTS.put("&copy;", "\u00a9");
        REPLACEMENTS.put("&ordf;", "\u00aa");
        REPLACEMENTS.put("&laquo;", "\u00ab");
        REPLACEMENTS.put("&not;", "\u00ac");
        REPLACEMENTS.put("&reg;", "\u00ae");
        REPLACEMENTS.put("&macr;", "\u00af");
        REPLACEMENTS.put("&deg;", "\u00b0");
        REPLACEMENTS.put("&plusmn;", "\u00b1");
        REPLACEMENTS.put("&sup2;", "\u00b2");
        REPLACEMENTS.put("&sup3;", "\u00b3");
        REPLACEMENTS.put("&acute;", "\u00b4");
        REPLACEMENTS.put("&micro;", "\u00b5");
        REPLACEMENTS.put("&para;", "\u00b6");
        REPLACEMENTS.put("&middot;", "\u00b7");
        REPLACEMENTS.put("&cedil;", "\u00b8");
        REPLACEMENTS.put("&sup1;", "\u00b9");
        REPLACEMENTS.put("&ordm;", "\u00ba");
        REPLACEMENTS.put("&raquo;", "\u00bb");
        REPLACEMENTS.put("&frac14;", "\u00bc");
        REPLACEMENTS.put("&frac12;", "\u00bd");
        REPLACEMENTS.put("&frac34;", "\u00be");
        REPLACEMENTS.put("&iquest;", "\u00bf");
        REPLACEMENTS.put("&times;", "\u00d7");
        REPLACEMENTS.put("&divide;", "\u00f7");
        REPLACEMENTS.put("&Agrave;", "\u00c0");
        REPLACEMENTS.put("&Aacute;", "\u00c1");
        REPLACEMENTS.put("&Acirc;", "\u00c2");
        REPLACEMENTS.put("&Atilde;", "\u00c3");
        REPLACEMENTS.put("&Auml;", "\u00c4");
        REPLACEMENTS.put("&Aring;", "\u00c5");
        REPLACEMENTS.put("&AElig;", "\u00c6");
        REPLACEMENTS.put("&Ccedil;", "\u00c7");
        REPLACEMENTS.put("&Egrave;", "\u00c8");
        REPLACEMENTS.put("&Eacute;", "\u00c9");
        REPLACEMENTS.put("&Ecirc;", "\u00ca");
        REPLACEMENTS.put("&Euml;", "\u00cb");
        REPLACEMENTS.put("&Igrave;", "\u00cc");
        REPLACEMENTS.put("&Iacute;", "\u00cd");
        REPLACEMENTS.put("&Icirc;", "\u00ce");
        REPLACEMENTS.put("&Iuml;", "\u00cf");
        REPLACEMENTS.put("&ETH;", "\u00d0");
        REPLACEMENTS.put("&Ntilde;", "\u00d1");
        REPLACEMENTS.put("&Ograve;", "\u00d2");
        REPLACEMENTS.put("&Oacute;", "\u00d3");
        REPLACEMENTS.put("&Ocirc;", "\u00d4");
        REPLACEMENTS.put("&Otilde;", "\u00d5");
        REPLACEMENTS.put("&Ouml;", "\u00d6");
        REPLACEMENTS.put("&Oslash;", "\u00d8");
        REPLACEMENTS.put("&Ugrave;", "\u00d9");
        REPLACEMENTS.put("&Uacute;", "\u00da");
        REPLACEMENTS.put("&Ucirc;", "\u00db");
        REPLACEMENTS.put("&Uuml;", "\u00dc");
        REPLACEMENTS.put("&Yacute;", "\u00dd");
        REPLACEMENTS.put("&THORN;", "\u00de");
        REPLACEMENTS.put("&szlig;", "\u00df");
        REPLACEMENTS.put("&agrave;", "\u00e0");
        REPLACEMENTS.put("&aacute;", "\u00e1");
        REPLACEMENTS.put("&acirc;", "\u00e2");
        REPLACEMENTS.put("&atilde;", "\u00e3");
        REPLACEMENTS.put("&auml;", "\u00e4");
        REPLACEMENTS.put("&aring;", "\u00e5");
        REPLACEMENTS.put("&aelig;", "\u00e6");
        REPLACEMENTS.put("&ccedil;", "\u00e7");
        REPLACEMENTS.put("&egrave;", "\u00e8");
        REPLACEMENTS.put("&eacute;", "\u00e9");
        REPLACEMENTS.put("&ecirc;", "\u00ea");
        REPLACEMENTS.put("&euml;", "\u00eb");
        REPLACEMENTS.put("&igrave;", "\u00ec");
        REPLACEMENTS.put("&iacute;", "\u00ed");
        REPLACEMENTS.put("&icirc;", "\u00ee");
        REPLACEMENTS.put("&iuml;", "\u00ef");
        REPLACEMENTS.put("&eth;", "\u00f0");
        REPLACEMENTS.put("&ntilde;", "\u00f1");
        REPLACEMENTS.put("&ograve;", "\u00f2");
        REPLACEMENTS.put("&oacute;", "\u00f3");
        REPLACEMENTS.put("&ocirc;", "\u00f4");
        REPLACEMENTS.put("&otilde;", "\u00f5");
        REPLACEMENTS.put("&ouml;", "\u00f6");
        REPLACEMENTS.put("&oslash;", "\u00f8");
        REPLACEMENTS.put("&ugrave;", "\u00f9");
        REPLACEMENTS.put("&uacute;", "\u00fa");
        REPLACEMENTS.put("&ucirc;", "\u00fb");
        REPLACEMENTS.put("&uuml;", "\u00fc");
        REPLACEMENTS.put("&yacute;", "\u00fd");
        REPLACEMENTS.put("&thorn;", "\u00fe");
        REPLACEMENTS.put("&yuml;", "\u00ff");
    }
}

